/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.avro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;

public final class AtleonReflectData
extends ReflectData {
    private static final AtleonReflectData INSTANCE = new AtleonReflectData();

    public static AtleonReflectData get() {
        return INSTANCE;
    }

    public ReflectDatumReader<?> createDatumReader(Schema writer, Schema reader) {
        return new DatumReader(writer, reader, this);
    }

    private static final class DatumReader<T>
    extends ReflectDatumReader<T> {
        private static final Map<String, Supplier<?>> CREATORS_BY_CLASS_NAME = DatumReader.createCreatorsByClassName();

        public DatumReader(Schema writer, Schema reader, ReflectData data) {
            super(writer, reader, data);
        }

        protected Object newArray(Object old, int size, Schema schema) {
            Supplier<?> creator = CREATORS_BY_CLASS_NAME.get(schema.getProp("java-class"));
            return old == null && creator != null ? creator.get() : super.newArray(old, size, schema);
        }

        private static Map<String, Supplier<?>> createCreatorsByClassName() {
            HashMap creatorsByClassName = new HashMap();
            creatorsByClassName.put(Set.class.getName(), HashSet::new);
            creatorsByClassName.put(SortedSet.class.getName(), TreeSet::new);
            return creatorsByClassName;
        }
    }

    public static final class AllowNull
    extends ReflectData.AllowNull {
        public ReflectDatumReader<?> createDatumReader(Schema writer, Schema reader) {
            return new DatumReader(writer, reader, (ReflectData)this);
        }
    }
}

