/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.avro;

import io.atleon.avro.AtleonReflectData;
import io.atleon.avro.AvroSchemaCache;
import io.atleon.avro.AvroSchemas;
import io.atleon.avro.AvroSerialization;
import io.atleon.avro.GenericDatas;
import io.atleon.schema.SchemaBytes;
import io.atleon.schema.SchematicPreSerializer;
import io.atleon.schema.SchematicSerializer;
import io.atleon.util.Throwing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public final class AvroSerializer<T>
implements SchematicSerializer<T, Schema> {
    private final GenericData genericData;
    private final Function<Type, Schema> typeSchemaLoader;
    private final boolean schemaCachingEnabled;
    private final boolean schemaGenerationEnabled;
    private final EnumSet<Transform> transforms;
    private final AvroSchemaCache<Class<?>> schemaCache = new AvroSchemaCache();
    private final AvroSchemaCache<Schema> transformedSchemas = new AvroSchemaCache();

    private AvroSerializer(GenericData genericData, Function<Type, Schema> typeSchemaLoader) {
        this(genericData, typeSchemaLoader, false, false, EnumSet.noneOf(Transform.class));
    }

    private AvroSerializer(GenericData genericData, Function<Type, Schema> typeSchemaLoader, boolean schemaCachingEnabled, boolean schemaGenerationEnabled, EnumSet<Transform> transforms) {
        this.genericData = genericData;
        this.typeSchemaLoader = typeSchemaLoader;
        this.schemaCachingEnabled = schemaCachingEnabled;
        this.schemaGenerationEnabled = schemaGenerationEnabled;
        this.transforms = transforms;
    }

    public static <T> AvroSerializer<T> generic() {
        return AvroSerializer.create(GenericData.get());
    }

    public static <T> AvroSerializer<T> reflect() {
        return AvroSerializer.create((GenericData)AtleonReflectData.get());
    }

    public static <T> AvroSerializer<T> create(GenericData genericData) {
        return new AvroSerializer<T>(genericData, GenericDatas.createTypeSchemaLoader(genericData));
    }

    public AvroSerializer<T> withSchemaCachingEnabled(boolean schemaCachingEnabled) {
        return new AvroSerializer<T>(this.genericData, this.typeSchemaLoader, schemaCachingEnabled, this.schemaGenerationEnabled, this.transforms);
    }

    public AvroSerializer<T> withSchemaGenerationEnabled(boolean schemaGenerationEnabled) {
        return new AvroSerializer<T>(this.genericData, this.typeSchemaLoader, this.schemaCachingEnabled, schemaGenerationEnabled, this.transforms);
    }

    public AvroSerializer<T> withRemoveJavaProperties(boolean removeJavaProperties) {
        return new AvroSerializer<T>(this.genericData, this.typeSchemaLoader, this.schemaCachingEnabled, this.schemaGenerationEnabled, AvroSerializer.modifyIfNecessary(this.transforms, Transform.REMOVE_JAVA_PROPERTIES, removeJavaProperties));
    }

    public SchemaBytes<Schema> serialize(T data, SchematicPreSerializer<Schema> preSerializer) {
        try {
            return this.serializeUnsafe(data, preSerializer);
        }
        catch (Exception e) {
            throw Throwing.propagate((Throwable)e);
        }
    }

    private SchemaBytes<Schema> serializeUnsafe(T data, SchematicPreSerializer<Schema> preSerializer) throws IOException {
        Schema schema = this.schemaCachingEnabled ? this.schemaCache.load(data.getClass(), __ -> this.loadSchema(data)) : this.loadSchema(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Schema writerSchema = (Schema)preSerializer.apply((Object)schema, outputStream);
        this.createDatumWriter(writerSchema).write(data, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null));
        return SchemaBytes.serialized((Object)writerSchema, (byte[])outputStream.toByteArray());
    }

    private Schema loadSchema(T data) {
        Supplier<Schema> supplier = this.schemaGenerationEnabled ? () -> AvroSerialization.generateWriterSchema(data, this.typeSchemaLoader) : () -> this.typeSchemaLoader.apply(data.getClass());
        Schema schema = AvroSchemas.getOrSupply(data, supplier);
        return this.transforms.isEmpty() ? schema : this.transformSchema(schema);
    }

    private Schema transformSchema(Schema schema) {
        return this.schemaCachingEnabled ? this.transformUncachedSchema(schema) : this.transformedSchemas.load(schema, this::transformUncachedSchema);
    }

    private Schema transformUncachedSchema(Schema schema) {
        if (this.transforms.contains((Object)Transform.REMOVE_JAVA_PROPERTIES)) {
            schema = AvroSchemas.removeJavaProperties(schema);
        }
        return schema;
    }

    private DatumWriter<T> createDatumWriter(Schema schema) {
        return this.genericData.createDatumWriter(schema);
    }

    private static <E extends Enum<E>> EnumSet<E> modifyIfNecessary(EnumSet<E> source, E value, boolean shouldContain) {
        EnumSet<E> result = EnumSet.copyOf(source);
        boolean modified = shouldContain ? result.add(value) : result.remove(value);
        return modified ? result : source;
    }

    private static enum Transform {
        REMOVE_JAVA_PROPERTIES;

    }
}

