/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.avro;

import io.atleon.avro.AtleonReflectData;
import io.atleon.avro.AvroDeserialization;
import io.atleon.avro.AvroSchemaCache;
import io.atleon.avro.AvroSchemas;
import io.atleon.avro.GenericDatas;
import io.atleon.schema.KeyableSchema;
import io.atleon.schema.SchematicDeserializer;
import io.atleon.util.Throwing;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroDeserializer<T>
implements SchematicDeserializer<T, Schema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroDeserializer.class);
    private final AvroSchemaCache<Serializable> readerSchemasByWriterKey = new AvroSchemaCache();
    private final GenericData genericData;
    private final Function<Type, Schema> typeSchemaLoader;
    private final boolean readerSchemaLoadingEnabled;
    private final boolean readerReferenceSchemaGenerationEnabled;

    private AvroDeserializer(GenericData genericData, Function<Type, Schema> typeSchemaLoader) {
        this(genericData, typeSchemaLoader, genericData instanceof SpecificData, false);
    }

    private AvroDeserializer(GenericData genericData, Function<Type, Schema> typeSchemaLoader, boolean readerSchemaLoadingEnabled, boolean readerReferenceSchemaGenerationEnabled) {
        this.genericData = genericData;
        this.typeSchemaLoader = typeSchemaLoader;
        this.readerSchemaLoadingEnabled = readerSchemaLoadingEnabled;
        this.readerReferenceSchemaGenerationEnabled = readerReferenceSchemaGenerationEnabled;
    }

    public static <T> AvroDeserializer<T> generic() {
        return AvroDeserializer.create(GenericData.get());
    }

    public static <T> AvroDeserializer<T> specific() {
        return AvroDeserializer.create((GenericData)SpecificData.get());
    }

    public static <T> AvroDeserializer<T> reflect() {
        return AvroDeserializer.create((GenericData)AtleonReflectData.get());
    }

    public static <T> AvroDeserializer<T> create(GenericData genericData) {
        return new AvroDeserializer<T>(genericData, GenericDatas.createTypeSchemaLoader(genericData));
    }

    public AvroDeserializer<T> withReaderSchemaLoadingEnabled(boolean readerSchemaLoadingEnabled) {
        return new AvroDeserializer<T>(this.genericData, this.typeSchemaLoader, readerSchemaLoadingEnabled, this.readerReferenceSchemaGenerationEnabled);
    }

    public AvroDeserializer<T> withReaderReferenceSchemaGenerationEnabled(boolean readerReferenceSchemaGenerationEnabled) {
        return new AvroDeserializer<T>(this.genericData, this.typeSchemaLoader, this.readerSchemaLoadingEnabled, readerReferenceSchemaGenerationEnabled);
    }

    public T deserialize(byte[] data, Function<ByteBuffer, KeyableSchema<Schema>> dataBufferToWriterSchema) {
        try {
            return this.deserializeUnsafe(data, dataBufferToWriterSchema);
        }
        catch (IOException e) {
            throw Throwing.propagate((Throwable)e);
        }
    }

    private T deserializeUnsafe(byte[] data, Function<ByteBuffer, KeyableSchema<Schema>> dataBufferToWriterSchema) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        KeyableSchema<Schema> keyableWriterSchema = dataBufferToWriterSchema.apply(buffer);
        Schema readerSchema = keyableWriterSchema.key().map(writerKey -> this.readerSchemasByWriterKey.load((Serializable)writerKey, __ -> this.loadReaderSchema((Schema)keyableWriterSchema.schema()))).orElseGet(() -> this.loadReaderSchema((Schema)keyableWriterSchema.schema()));
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), null);
        return (T)this.createDatumReader((Schema)keyableWriterSchema.schema(), readerSchema).read(null, (Decoder)decoder);
    }

    private Schema loadReaderSchema(Schema writerSchema) {
        try {
            return this.readerSchemaLoadingEnabled ? this.loadReaderSchemaUnsafe(writerSchema) : writerSchema;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load readerSchema. Defaulting to writerSchema={}", (Object)writerSchema, (Object)e);
            return writerSchema;
        }
    }

    private Schema loadReaderSchemaUnsafe(Schema writerSchema) {
        Object referenceData = AvroDeserialization.instantiateReferenceData(writerSchema);
        return AvroSchemas.getOrSupply(referenceData, () -> this.loadReaderSchemaUnsafe(writerSchema, referenceData));
    }

    private Schema loadReaderSchemaUnsafe(Schema writerSchema, Object referenceData) {
        return this.readerReferenceSchemaGenerationEnabled ? AvroDeserialization.generateReaderReferenceSchema(referenceData, writerSchema, this.typeSchemaLoader) : this.typeSchemaLoader.apply(referenceData.getClass());
    }

    private DatumReader<T> createDatumReader(Schema writerSchema, Schema readerSchema) {
        return this.genericData.createDatumReader(writerSchema, readerSchema);
    }
}

