/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.amqp.embedded;

import io.atleon.amqp.embedded.EmbeddedAmqpConfig;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.SystemLauncher;
import org.apache.qpid.server.model.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedAmqp {
    public static final int DEFAULT_PORT = 5672;
    private static final String PORT_PROPERTY = "port";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedAmqp.class);
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\..*");
    private static EmbeddedAmqpConfig config;

    public static EmbeddedAmqpConfig start() {
        return EmbeddedAmqp.start(5672);
    }

    public static synchronized EmbeddedAmqpConfig start(int port) {
        return config == null ? (config = EmbeddedAmqp.initializeAmqp(port)) : config;
    }

    private static EmbeddedAmqpConfig initializeAmqp(int port) {
        EmbeddedAmqpConfig config = new EmbeddedAmqpConfig("localhost", port, "/", "guest", "guest");
        EmbeddedAmqp.startLocalBroker(config);
        return config;
    }

    private static void startLocalBroker(EmbeddedAmqpConfig config) {
        try {
            LOGGER.info("BEGINNING STARTUP OF LOCAL AMQP BROKER");
            Path tempDirectory = Files.createTempDirectory(EmbeddedAmqp.class.getSimpleName() + "_" + System.currentTimeMillis(), new FileAttribute[0]);
            System.getProperties().putIfAbsent("derby.stream.error.file", new File(tempDirectory.toFile(), "derby.log").getAbsolutePath());
            Map<String, Object> attributes = EmbeddedAmqp.createAttributes(config, tempDirectory);
            SystemLauncher systemLauncher = new SystemLauncher();
            systemLauncher.startup(attributes);
            LOGGER.info("FINISHED STARTUP OF LOCAL AMQP BROKER");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start local Broker: " + e);
        }
    }

    private static Map<String, Object> createAttributes(EmbeddedAmqpConfig config, Path tempDirectory) throws Exception {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(PORT_PROPERTY, Integer.toString(config.getPort()));
        context.put(USERNAME_PROPERTY, config.getUsername());
        context.put(PASSWORD_PROPERTY, config.getPassword());
        context.put("qpid.work_dir", tempDirectory.toString());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("type", "JSON");
        attributes.put("initialConfigurationLocation", EmbeddedAmqp.createAmqpConfig(tempDirectory).getCanonicalPath());
        attributes.put("context", context);
        return attributes;
    }

    private static File createAmqpConfig(Path directory) throws Exception {
        File configFile = Files.createTempFile(directory, "amqp", "initial-config.json", new FileAttribute[0]).toFile();
        PrintWriter configWriter = new PrintWriter(configFile);
        configWriter.println("{");
        configWriter.println("    \"name\": \"broker\",");
        configWriter.println("    \"modelVersion\": \"" + EmbeddedAmqp.deduceQpidConfigModelVersion() + "\",");
        configWriter.println("    \"virtualhostnodes\": [{");
        configWriter.println("        \"type\": \"Memory\",");
        configWriter.println("        \"name\": \"default\",");
        configWriter.println("        \"defaultVirtualHostNode\": \"true\",");
        configWriter.println("        \"virtualHostInitialConfiguration\": \"{\\\"type\\\": \\\"Memory\\\"}\"");
        configWriter.println("    }],");
        configWriter.println("    \"authenticationproviders\": [{");
        configWriter.println("        \"type\": \"Plain\",");
        configWriter.println("        \"name\": \"plain\",");
        configWriter.println("        \"users\": [{");
        configWriter.println("            \"type\": \"managed\",");
        configWriter.println("            \"name\": \"${username}\",");
        configWriter.println("            \"password\": \"${password}\"");
        configWriter.println("        }],");
        configWriter.println("        \"secureOnlyMechanisms\": []");
        configWriter.println("    }],");
        configWriter.println("    \"ports\": [{");
        configWriter.println("        \"name\": \"AMQP\",");
        configWriter.println("        \"port\": \"${port}\",");
        configWriter.println("        \"transports\": [\"TCP\"],");
        configWriter.println("        \"authenticationProvider\": \"plain\",");
        configWriter.println("        \"virtualhostaliases\": [{");
        configWriter.println("            \"type\": \"defaultAlias\",");
        configWriter.println("            \"name\": \"defaultAlias\"");
        configWriter.println("        }, {");
        configWriter.println("            \"type\": \"hostnameAlias\",");
        configWriter.println("            \"name\": \"hostnameAlias\"");
        configWriter.println("        }, {");
        configWriter.println("            \"type\": \"nameAlias\",");
        configWriter.println("            \"name\": \"nameAlias\"");
        configWriter.println("        }]");
        configWriter.println("    }]");
        configWriter.println("}");
        configWriter.flush();
        configWriter.close();
        return configFile;
    }

    private static String deduceQpidConfigModelVersion() {
        String version = SystemConfig.class.getPackage().getImplementationVersion();
        Matcher matcher = SEMVER_PATTERN.matcher(version);
        return matcher.find() ? String.format("%s.0", matcher.group(1)) : "7.0";
    }
}

