/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlSslConfiguration;
import io.asyncer.r2dbc.mysql.client.FluxExchangeable;
import io.asyncer.r2dbc.mysql.client.ReactorNettyClient;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.netty.Connection;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;

public interface Client {
    public static final InternalLogger logger = InternalLoggerFactory.getInstance(Client.class);

    public <T> Flux<T> exchange(ClientMessage var1, BiConsumer<ServerMessage, SynchronousSink<T>> var2);

    public <T> Flux<T> exchange(FluxExchangeable<T> var1);

    public Mono<Void> close();

    public Mono<Void> forceClose();

    public ByteBufAllocator getByteBufAllocator();

    public ConnectionContext getContext();

    public boolean isConnected();

    public void sslUnsupported();

    public void loginSuccess();

    public static Mono<Client> connect(MySqlSslConfiguration ssl, SocketAddress address, boolean tcpKeepAlive, boolean tcpNoDelay, ConnectionContext context, @Nullable Duration connectTimeout, LoopResources loopResources, @Nullable AddressResolverGroup<?> resolver) {
        AssertUtils.requireNonNull(ssl, "ssl must not be null");
        AssertUtils.requireNonNull(address, "address must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        TcpClient tcpClient = TcpClient.newConnection().runOn(loopResources);
        if (connectTimeout != null) {
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(connectTimeout.toMillis()));
        }
        if (address instanceof InetSocketAddress) {
            tcpClient = tcpClient.option(ChannelOption.SO_KEEPALIVE, (Object)tcpKeepAlive);
            tcpClient = tcpClient.option(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay);
        }
        if (resolver != null) {
            tcpClient = tcpClient.resolver(resolver);
        }
        return tcpClient.remoteAddress(() -> address).connect().map(conn -> new ReactorNettyClient((Connection)conn, ssl, context));
    }
}

