/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ErrorMessage
implements ServerMessage {
    private static final String CONSTRAINT_VIOLATION_PREFIX = "23";
    private static final String TRANSACTION_ROLLBACK_PREFIX = "40";
    private static final String SYNTAX_ERROR_PREFIX = "42";
    private static final int SQL_STATE_SIZE = 5;
    private final int code;
    @Nullable
    private final String sqlState;
    private final String message;
    @Nullable
    private final String offendingSql;

    private ErrorMessage(int code, @Nullable String sqlState, String message) {
        this(code, sqlState, message, null);
    }

    private ErrorMessage(int code, @Nullable String sqlState, String message, @Nullable String offendingSql) {
        this.code = code;
        this.sqlState = sqlState;
        this.message = AssertUtils.requireNonNull(message, "message must not be null");
        this.offendingSql = offendingSql;
    }

    public R2dbcException toException() {
        return this.toException(this.offendingSql);
    }

    public R2dbcException toException(@Nullable String sql) {
        switch (this.code) {
            case 1044: 
            case 1045: 
            case 1095: 
            case 1142: 
            case 1143: 
            case 1227: 
            case 1370: 
            case 1698: 
            case 1873: {
                return new R2dbcPermissionDeniedException(this.message, this.sqlState, this.code);
            }
            case 1159: 
            case 1161: 
            case 1213: 
            case 1317: {
                return new R2dbcTransientResourceException(this.message, this.sqlState, this.code);
            }
            case 1205: 
            case 1907: 
            case 1969: 
            case 3024: {
                return new R2dbcTimeoutException(this.message, this.sqlState, this.code);
            }
            case 1613: {
                return new R2dbcRollbackException(this.message, this.sqlState, this.code);
            }
            case 1050: 
            case 1051: 
            case 1054: 
            case 1064: 
            case 1146: 
            case 1247: 
            case 1304: 
            case 1305: 
            case 1630: {
                return new R2dbcBadGrammarException(this.message, this.sqlState, this.code, sql);
            }
            case 1022: 
            case 1048: 
            case 1062: 
            case 1169: 
            case 1215: 
            case 1216: 
            case 1217: 
            case 1364: 
            case 1451: 
            case 1452: 
            case 1557: 
            case 1859: {
                return new R2dbcDataIntegrityViolationException(this.message, this.sqlState, this.code);
            }
        }
        if (this.sqlState == null) {
            return new R2dbcNonTransientResourceException(this.message, null, this.code);
        }
        if (this.sqlState.startsWith(SYNTAX_ERROR_PREFIX)) {
            return new R2dbcBadGrammarException(this.message, this.sqlState, this.code, sql);
        }
        if (this.sqlState.startsWith(CONSTRAINT_VIOLATION_PREFIX)) {
            return new R2dbcDataIntegrityViolationException(this.message, this.sqlState, this.code);
        }
        if (this.sqlState.startsWith(TRANSACTION_ROLLBACK_PREFIX)) {
            return new R2dbcRollbackException(this.message, this.sqlState, this.code);
        }
        return new R2dbcNonTransientResourceException(this.message, null, this.code);
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getSqlState() {
        return this.sqlState;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorMessage offendedBy(@Nullable String sql) {
        return sql == null ? this : new ErrorMessage(this.code, this.sqlState, this.message, sql);
    }

    public static ErrorMessage decode(ByteBuf buf) {
        String sqlState;
        buf.skipBytes(1);
        int errorCode = buf.readUnsignedShortLE();
        if (35 == buf.getByte(buf.readerIndex())) {
            buf.skipBytes(1);
            sqlState = buf.toString(buf.readerIndex(), 5, StandardCharsets.US_ASCII);
            buf.skipBytes(5);
        } else {
            sqlState = null;
        }
        return new ErrorMessage(errorCode, sqlState, buf.toString(StandardCharsets.US_ASCII));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage that = (ErrorMessage)o;
        return this.code == that.code && Objects.equals(this.sqlState, that.sqlState) && this.message.equals(that.message) && Objects.equals(this.offendingSql, that.offendingSql);
    }

    public int hashCode() {
        int hash = 31 * this.code + Objects.hashCode(this.sqlState);
        return 31 * (31 * hash + this.message.hashCode()) + Objects.hashCode(this.offendingSql);
    }

    public String toString() {
        return "ErrorMessage{code=" + this.code + ", sqlState='" + this.sqlState + "', message='" + this.message + "'}";
    }
}

