/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.FluxDiscardOnCancel;
import io.asyncer.r2dbc.mysql.internal.util.FluxDiscardOnCancelFuseable;
import io.asyncer.r2dbc.mysql.internal.util.FluxEnvelope;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;

public final class OperatorUtils {
    public static <T> Flux<T> discardOnCancel(Flux<? extends T> source) {
        AssertUtils.requireNonNull(source, "source must not be null");
        if (source instanceof Fuseable) {
            return new FluxDiscardOnCancelFuseable<T>(source);
        }
        return new FluxDiscardOnCancel<T>(source);
    }

    public static Flux<ByteBuf> envelope(Flux<? extends ByteBuf> source, ByteBufAllocator allocator, int envelopeIdStart, boolean cumulate) {
        AssertUtils.requireNonNull(source, "source must not be null");
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        return new FluxEnvelope(source, allocator, 0xFFFFFF, envelopeIdStart & 0xFF, cumulate);
    }

    private OperatorUtils() {
    }
}

