/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

final class DirectEnvelopeSubscriber
implements CoreSubscriber<ByteBuf>,
Scannable,
Subscription {
    private final CoreSubscriber<? super ByteBuf> actual;
    private final ByteBufAllocator alloc;
    private boolean done;
    private Subscription s;
    private int envelopeId;

    DirectEnvelopeSubscriber(CoreSubscriber<? super ByteBuf> actual, ByteBufAllocator alloc, int start) {
        this.actual = actual;
        this.alloc = alloc;
        this.envelopeId = start;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(ByteBuf buf) {
        if (this.done) {
            Operators.onNextDropped((Object)buf, (Context)this.actual.currentContext());
            return;
        }
        try {
            ByteBuf header = this.alloc.buffer(4).writeMediumLE(buf.readableBytes()).writeByte(this.envelopeId++);
            this.actual.onNext((Object)header);
            this.actual.onNext((Object)buf);
        }
        catch (Throwable e) {
            Throwable t = Operators.onNextError((Object)buf, (Throwable)e, (Context)this.actual.currentContext(), (Subscription)this.s);
            if (t == null) {
                this.s.request(1L);
            }
            this.onError(t);
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
            return;
        }
        this.done = true;
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.s.cancel();
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.ACTUAL) {
            return this.actual;
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.done;
        }
        return null;
    }
}

