/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Otherwise;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

final class Source<T> {
    private static final Source<Object> NIL = new Source<Object>(null);
    @Nullable
    private final T value;

    private Source(@Nullable T value) {
        this.value = value;
    }

    Otherwise to(Consumer<? super T> consumer) {
        if (this.value == null) {
            return Otherwise.FALL;
        }
        consumer.accept(this.value);
        return Otherwise.NOOP;
    }

    <R> Source<R> as(Class<R> type) {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (type.isInstance(this.value)) {
            return new Source<R>(type.cast(this.value));
        }
        if (this.value instanceof String) {
            try {
                Class<?> impl = Class.forName((String)this.value);
                if (type.isAssignableFrom(impl)) {
                    return new Source<R>(type.cast(impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot instantiate '" + this.value + "'", e);
            }
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, type.getName()));
    }

    <R> Source<R> as(Class<R> type, Function<String, R> mapping) {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (type.isInstance(this.value)) {
            return new Source<R>(type.cast(this.value));
        }
        if (this.value instanceof String) {
            return new Source<R>(type.cast(mapping.apply((String)this.value)));
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, type.getTypeName()));
    }

    Source<String[]> asStrings() {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (this.value instanceof String[]) {
            return new Source<String[]>((String[])this.value);
        }
        if (this.value instanceof String) {
            return new Source<String[]>(((String)this.value).split(","));
        }
        if (this.value instanceof Collection) {
            return new Source<A[]>(((Collection)this.value).stream().map(String.class::cast).toArray(String[]::new));
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, "String[]"));
    }

    Source<Boolean> asBoolean() {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (this.value instanceof Boolean) {
            return new Source<Boolean>((Boolean)this.value);
        }
        if (this.value instanceof String) {
            return new Source<Boolean>(Boolean.parseBoolean((String)this.value));
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, "Boolean"));
    }

    Source<Integer> asInt() {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (this.value instanceof Integer) {
            return new Source<Integer>((Integer)this.value);
        }
        if (this.value instanceof Number) {
            return new Source<Integer>(((Number)this.value).intValue());
        }
        if (this.value instanceof String) {
            return new Source<Integer>(Integer.parseInt((String)this.value));
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, "Integer"));
    }

    Source<CharSequence> asPassword() {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (this.value instanceof CharSequence) {
            return new Source<CharSequence>((CharSequence)this.value);
        }
        throw new IllegalArgumentException(Source.toMessage("REDACTED", "CharSequence"));
    }

    Source<String> asString() {
        if (this.value == null) {
            return Source.nilSource();
        }
        if (this.value instanceof String) {
            return new Source<String>((String)this.value);
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, "String"));
    }

    void prepare(Runnable client, Runnable server, Consumer<Predicate<String>> preferred) {
        if (this.value == null) {
            return;
        }
        if (this.value instanceof Boolean) {
            if (((Boolean)this.value).booleanValue()) {
                server.run();
            } else {
                client.run();
            }
            return;
        }
        if (this.value instanceof Predicate) {
            preferred.accept((Predicate)this.value);
            return;
        }
        if (this.value instanceof String) {
            String stringify = (String)this.value;
            if ("true".equalsIgnoreCase(stringify)) {
                server.run();
                return;
            }
            if ("false".equalsIgnoreCase(stringify)) {
                client.run();
                return;
            }
            try {
                Class<?> impl = Class.forName(stringify);
                if (Predicate.class.isAssignableFrom(impl)) {
                    preferred.accept((Predicate)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    return;
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot instantiate '" + this.value + "'", e);
            }
        }
        throw new IllegalArgumentException(Source.toMessage(this.value, "Boolean or Predicate<String>"));
    }

    static Source<Object> of(@Nullable Object value) {
        if (value == null) {
            return NIL;
        }
        return new Source<Object>(value);
    }

    private static <T> Source<T> nilSource() {
        return NIL;
    }

    private static String toMessage(Object value, String type) {
        return "Cannot convert value " + value + " to " + type;
    }
}

