/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.MySqlResult;
import io.asyncer.r2dbc.mysql.MySqlStatement;
import io.asyncer.r2dbc.mysql.MySqlStatementSupport;
import io.asyncer.r2dbc.mysql.ParameterIndex;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;

abstract class ParametrizedStatementSupport
extends MySqlStatementSupport {
    protected final Client client;
    protected final Codecs codecs;
    protected final Query query;
    private final Bindings bindings;
    private final AtomicBoolean executed = new AtomicBoolean();

    ParametrizedStatementSupport(Client client, Codecs codecs, Query query, ConnectionContext context) {
        super(context);
        AssertUtils.requireNonNull(query, "query must not be null");
        AssertUtils.require(query.getParameters() > 0, "parameters must be a positive integer");
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.query = query;
        this.bindings = new Bindings(query.getParameters());
    }

    @Override
    public final MySqlStatement add() {
        this.assertNotExecuted();
        this.bindings.validatedFinish();
        return this;
    }

    @Override
    public final MySqlStatement bind(int index, Object value) {
        AssertUtils.requireNonNull(value, "value must not be null");
        this.addBinding(index, this.codecs.encode(value, this.context));
        return this;
    }

    @Override
    public final MySqlStatement bind(String name, Object value) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        this.addBinding(this.getIndexes(name), this.codecs.encode(value, this.context));
        return this;
    }

    @Override
    public final MySqlStatement bindNull(int index, Class<?> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        this.addBinding(index, this.codecs.encodeNull());
        return this;
    }

    @Override
    public final MySqlStatement bindNull(String name, Class<?> type) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        this.addBinding(this.getIndexes(name), this.codecs.encodeNull());
        return this;
    }

    @Override
    public final Flux<MySqlResult> execute() {
        if (this.bindings.bindings.isEmpty()) {
            throw new IllegalStateException("No parameters bound for current statement");
        }
        this.bindings.validatedFinish();
        return Flux.defer(() -> {
            if (!this.executed.compareAndSet(false, true)) {
                return Flux.error((Throwable)new IllegalStateException("Parametrized statement was already executed"));
            }
            return this.execute(this.bindings.bindings);
        });
    }

    protected abstract Flux<MySqlResult> execute(List<Binding> var1);

    private ParameterIndex getIndexes(String name) {
        ParameterIndex index = this.query.getNamedIndexes().get(name);
        if (index == null) {
            throw new NoSuchElementException("No such parameter with name: " + name);
        }
        return index;
    }

    private void addBinding(int index, MySqlParameter value) {
        this.assertNotExecuted();
        this.bindings.getCurrent().add(index, value);
    }

    private void addBinding(ParameterIndex indexes, MySqlParameter value) {
        this.assertNotExecuted();
        indexes.bind(this.bindings.getCurrent(), value);
    }

    private void assertNotExecuted() {
        if (this.executed.get()) {
            throw new IllegalStateException("Statement was already executed");
        }
    }

    private static final class Bindings
    implements Iterable<Binding> {
        private final List<Binding> bindings = new ArrayList<Binding>();
        private final int paramCount;
        private Binding current;

        private Bindings(int paramCount) {
            this.paramCount = paramCount;
        }

        @Override
        public Iterator<Binding> iterator() {
            return this.bindings.iterator();
        }

        @Override
        public void forEach(Consumer<? super Binding> action) {
            this.bindings.forEach(action);
        }

        @Override
        public Spliterator<Binding> spliterator() {
            return this.bindings.spliterator();
        }

        private void validatedFinish() {
            Binding current = this.current;
            if (current == null) {
                throw new IllegalStateException("Not all parameter values are provided yet.");
            }
            int unbind = current.findUnbind();
            if (unbind >= 0) {
                String message = String.format("Parameter %d has no binding", unbind);
                throw new IllegalStateException(message);
            }
            this.current = null;
        }

        private Binding getCurrent() {
            Binding current = this.current;
            if (current == null) {
                this.current = current = new Binding(this.paramCount);
                this.bindings.add(current);
            }
            return current;
        }
    }
}

