/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.ConnectionState;
import io.asyncer.r2dbc.mysql.MySqlBatch;
import io.asyncer.r2dbc.mysql.MySqlBatchingBatch;
import io.asyncer.r2dbc.mysql.MySqlConnectionMetadata;
import io.asyncer.r2dbc.mysql.MySqlResult;
import io.asyncer.r2dbc.mysql.MySqlStatement;
import io.asyncer.r2dbc.mysql.MySqlSyntheticBatch;
import io.asyncer.r2dbc.mysql.MySqlTransactionDefinition;
import io.asyncer.r2dbc.mysql.PingStatement;
import io.asyncer.r2dbc.mysql.PrepareParametrizedStatement;
import io.asyncer.r2dbc.mysql.PrepareSimpleStatement;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.TextParametrizedStatement;
import io.asyncer.r2dbc.mysql.TextSimpleStatement;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import io.asyncer.r2dbc.mysql.cache.QueryCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.client.InitDbMessage;
import io.asyncer.r2dbc.mysql.message.client.PingMessage;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Lifecycle;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public final class MySqlConnection
implements Connection,
Lifecycle,
ConnectionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MySqlConnection.class);
    private static final int DEFAULT_LOCK_WAIT_TIMEOUT = 50;
    private static final String PING_MARKER = "/* ping */";
    private static final String ZONE_PREFIX_POSIX = "posix/";
    private static final String ZONE_PREFIX_RIGHT = "right/";
    private static final int PREFIX_LENGTH = 6;
    private static final ServerVersion MARIA_11_1_1 = ServerVersion.create(11, 1, 1, true);
    private static final ServerVersion MYSQL_8_0_3 = ServerVersion.create(8, 0, 3);
    private static final ServerVersion MYSQL_5_7_20 = ServerVersion.create(5, 7, 20);
    private static final ServerVersion MYSQL_8 = ServerVersion.create(8, 0, 0);
    private static final ServerVersion MYSQL_5_7_4 = ServerVersion.create(5, 7, 4);
    private static final ServerVersion MARIA_10_1_1 = ServerVersion.create(10, 1, 1, true);
    private static final Function<ServerMessage, Boolean> VALIDATE = message -> {
        if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            return true;
        }
        if (message instanceof ErrorMessage) {
            ErrorMessage msg = (ErrorMessage)message;
            logger.debug("Remote validate failed: [{}] [{}] {}", new Object[]{msg.getCode(), msg.getSqlState(), msg.getMessage()});
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
        return false;
    };
    private static final BiConsumer<ServerMessage, SynchronousSink<ServerMessage>> PING = (message, sink) -> {
        if (message instanceof ErrorMessage) {
            sink.next(message);
            sink.complete();
        } else if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            sink.next(message);
            sink.complete();
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
    };
    private static final BiConsumer<ServerMessage, SynchronousSink<Boolean>> INIT_DB = (message, sink) -> {
        if (message instanceof ErrorMessage) {
            ErrorMessage msg = (ErrorMessage)message;
            logger.debug("Use database failed: [{}] [{}] {}", new Object[]{msg.getCode(), msg.getSqlState(), msg.getMessage()});
            sink.next((Object)false);
            sink.complete();
        } else if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            sink.next((Object)true);
            sink.complete();
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
    };
    private static final BiConsumer<ServerMessage, SynchronousSink<Void>> INIT_DB_AFTER = (message, sink) -> {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)((ErrorMessage)message).toException());
        } else if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            sink.complete();
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
    };
    private final Client client;
    private final Codecs codecs;
    private final boolean batchSupported;
    private final ConnectionContext context;
    private final MySqlConnectionMetadata metadata;
    private volatile IsolationLevel sessionLevel;
    private final QueryCache queryCache;
    private final PrepareCache prepareCache;
    @Nullable
    private final Predicate<String> prepare;
    private volatile IsolationLevel currentLevel;
    private volatile long lockWaitTimeout;
    private volatile long currentLockWaitTimeout;

    MySqlConnection(Client client, ConnectionContext context, Codecs codecs, IsolationLevel level, long lockWaitTimeout, QueryCache queryCache, PrepareCache prepareCache, @Nullable String product, @Nullable Predicate<String> prepare) {
        this.client = client;
        this.context = context;
        this.sessionLevel = level;
        this.currentLevel = level;
        this.codecs = codecs;
        this.lockWaitTimeout = lockWaitTimeout;
        this.currentLockWaitTimeout = lockWaitTimeout;
        this.queryCache = queryCache;
        this.prepareCache = prepareCache;
        this.metadata = new MySqlConnectionMetadata(context.getServerVersion().toString(), product);
        this.batchSupported = context.getCapability().isMultiStatementsAllowed();
        this.prepare = prepare;
        if (this.batchSupported) {
            logger.debug("Batch is supported by server");
        } else {
            logger.warn("The MySQL server does not support batch, fallback to executing one-by-one");
        }
    }

    public Mono<Void> beginTransaction() {
        return this.beginTransaction(MySqlTransactionDefinition.empty());
    }

    public Mono<Void> beginTransaction(TransactionDefinition definition) {
        return Mono.defer(() -> QueryFlow.beginTransaction(this.client, this, this.batchSupported, definition));
    }

    public Mono<Void> close() {
        Mono<Void> closer = this.client.close();
        if (logger.isDebugEnabled()) {
            return closer.doOnSubscribe(s -> logger.debug("Connection closing")).doOnSuccess(ignored -> logger.debug("Connection close succeed"));
        }
        return closer;
    }

    public Mono<Void> commitTransaction() {
        return Mono.defer(() -> QueryFlow.doneTransaction(this.client, this, true, this.batchSupported));
    }

    public MySqlBatch createBatch() {
        return this.batchSupported ? new MySqlBatchingBatch(this.client, this.codecs, this.context) : new MySqlSyntheticBatch(this.client, this.codecs, this.context);
    }

    public Mono<Void> createSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.createSavepoint(this.client, this, name, this.batchSupported);
    }

    public MySqlStatement createStatement(String sql) {
        AssertUtils.requireNonNull(sql, "sql must not be null");
        if (sql.startsWith(PING_MARKER)) {
            return new PingStatement(this, this.codecs, this.context);
        }
        Query query = this.queryCache.get(sql);
        if (query.isSimple()) {
            if (this.prepare != null && this.prepare.test(sql)) {
                logger.debug("Create a simple statement provided by prepare query");
                return new PrepareSimpleStatement(this.client, this.codecs, this.context, sql, this.prepareCache);
            }
            logger.debug("Create a simple statement provided by text query");
            return new TextSimpleStatement(this.client, this.codecs, this.context, sql);
        }
        if (this.prepare == null) {
            logger.debug("Create a parametrized statement provided by text query");
            return new TextParametrizedStatement(this.client, this.codecs, query, this.context);
        }
        logger.debug("Create a parametrized statement provided by prepare query");
        return new PrepareParametrizedStatement(this.client, this.codecs, query, this.context, this.prepareCache);
    }

    public Mono<Void> postAllocate() {
        return Mono.empty();
    }

    public Mono<Void> preRelease() {
        return this.rollbackTransaction();
    }

    public Mono<Void> releaseSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.executeVoid(this.client, "RELEASE SAVEPOINT " + StringUtils.quoteIdentifier(name));
    }

    public Mono<Void> rollbackTransaction() {
        return Mono.defer(() -> QueryFlow.doneTransaction(this.client, this, false, this.batchSupported));
    }

    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.executeVoid(this.client, "ROLLBACK TO SAVEPOINT " + StringUtils.quoteIdentifier(name));
    }

    public MySqlConnectionMetadata getMetadata() {
        return this.metadata;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.currentLevel;
    }

    IsolationLevel getSessionTransactionIsolationLevel() {
        return this.sessionLevel;
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        AssertUtils.requireNonNull(isolationLevel, "isolationLevel must not be null");
        return QueryFlow.executeVoid(this.client, "SET SESSION TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql()).doOnSuccess(ignored -> {
            this.sessionLevel = isolationLevel;
            if (!this.isInTransaction()) {
                this.currentLevel = isolationLevel;
            }
        });
    }

    public Mono<Boolean> validate(ValidationDepth depth) {
        AssertUtils.requireNonNull(depth, "depth must not be null");
        if (depth == ValidationDepth.LOCAL) {
            return Mono.fromSupplier(this.client::isConnected);
        }
        return Mono.defer(() -> {
            if (!this.client.isConnected()) {
                return Mono.just((Object)false);
            }
            return this.doPingInternal().last().map(VALIDATE).onErrorResume(e -> {
                logger.debug("Remote validate failed", e);
                return Mono.just((Object)false);
            });
        });
    }

    public boolean isAutoCommit() {
        return !this.isInTransaction() && this.isSessionAutoCommit();
    }

    public Mono<Void> setAutoCommit(boolean autoCommit) {
        return Mono.defer(() -> {
            if (autoCommit == this.isSessionAutoCommit()) {
                return Mono.empty();
            }
            return QueryFlow.executeVoid(this.client, "SET autocommit=" + (autoCommit ? 1 : 0));
        });
    }

    @Override
    public void setIsolationLevel(IsolationLevel level) {
        this.currentLevel = level;
    }

    @Override
    public long getSessionLockWaitTimeout() {
        return this.lockWaitTimeout;
    }

    @Override
    public void setCurrentLockWaitTimeout(long timeoutSeconds) {
        this.currentLockWaitTimeout = timeoutSeconds;
    }

    @Override
    public void resetIsolationLevel() {
        this.currentLevel = this.sessionLevel;
    }

    @Override
    public boolean isLockWaitTimeoutChanged() {
        return this.currentLockWaitTimeout != this.lockWaitTimeout;
    }

    @Override
    public void resetCurrentLockWaitTimeout() {
        this.currentLockWaitTimeout = this.lockWaitTimeout;
    }

    @Override
    public boolean isInTransaction() {
        return (this.context.getServerStatuses() & 1) != 0;
    }

    public Mono<Void> setLockWaitTimeout(Duration timeout) {
        AssertUtils.requireNonNull(timeout, "timeout must not be null");
        long timeoutSeconds = timeout.getSeconds();
        return QueryFlow.executeVoid(this.client, "SET innodb_lock_wait_timeout=" + timeoutSeconds).doOnSuccess(ignored -> {
            this.lockWaitTimeout = this.currentLockWaitTimeout = timeoutSeconds;
        });
    }

    public Mono<Void> setStatementTimeout(Duration timeout) {
        String sql;
        AssertUtils.requireNonNull(timeout, "timeout must not be null");
        boolean isMariaDb = this.context.isMariaDb();
        ServerVersion serverVersion = this.context.getServerVersion();
        long timeoutMs = timeout.toMillis();
        String string = sql = isMariaDb ? "SET max_statement_time=" + (double)timeoutMs / 1000.0 : "SET SESSION MAX_EXECUTION_TIME=" + timeoutMs;
        if (isMariaDb && serverVersion.isGreaterThanOrEqualTo(MARIA_10_1_1) || !isMariaDb && serverVersion.isGreaterThanOrEqualTo(MYSQL_5_7_4)) {
            return QueryFlow.executeVoid(this.client, sql);
        }
        return Mono.error((Throwable)new R2dbcNonTransientResourceException("Statement timeout is not supported by server version " + serverVersion, "HY000", -1, sql));
    }

    Flux<ServerMessage> doPingInternal() {
        return this.client.exchange(PingMessage.INSTANCE, PING);
    }

    boolean isSessionAutoCommit() {
        return (this.context.getServerStatuses() & 2) != 0;
    }

    static Mono<MySqlConnection> init(Client client, Codecs codecs, ConnectionContext context, String database, QueryCache queryCache, PrepareCache prepareCache, @Nullable Predicate<String> prepare) {
        Function<MySqlResult, Publisher> handler;
        StringBuilder query = new StringBuilder(128).append("SELECT ").append(MySqlConnection.transactionIsolationColumn(context)).append(",@@innodb_lock_wait_timeout AS l,@@version_comment AS v");
        if (context.shouldSetServerZoneId()) {
            query.append(",@@system_time_zone AS s,@@time_zone AS t");
            handler = MySqlConnection::fullInit;
        } else {
            handler = MySqlConnection::init;
        }
        Mono connection = new TextSimpleStatement(client, codecs, context, query.toString()).execute().flatMap(handler).last().map(data -> {
            ZoneId serverZoneId = ((InitData)data).serverZoneId;
            if (serverZoneId != null) {
                logger.debug("Set server time zone to {} from init query", (Object)serverZoneId);
                context.setServerZoneId(serverZoneId);
            }
            return new MySqlConnection(client, context, codecs, ((InitData)data).level, ((InitData)data).lockWaitTimeout, queryCache, prepareCache, ((InitData)data).product, prepare);
        });
        if (database.isEmpty()) {
            return connection;
        }
        AssertUtils.requireNonEmpty(database, "database must not be empty");
        return connection.flatMap(conn -> client.exchange(new InitDbMessage(database), INIT_DB).last().flatMap(success -> {
            if (success.booleanValue()) {
                return Mono.just((Object)conn);
            }
            String sql = "CREATE DATABASE IF NOT EXISTS " + StringUtils.quoteIdentifier(database);
            return QueryFlow.executeVoid(client, sql).then(client.exchange(new InitDbMessage(database), INIT_DB_AFTER).then(Mono.just((Object)conn)));
        }));
    }

    private static Publisher<InitData> init(MySqlResult r) {
        return r.map((row, meta) -> new InitData(MySqlConnection.convertIsolationLevel((String)row.get(0, String.class)), MySqlConnection.convertLockWaitTimeout((Long)row.get(1, Long.class)), (String)row.get(2, String.class), null));
    }

    private static Publisher<InitData> fullInit(MySqlResult r) {
        return r.map((row, meta) -> {
            ZoneId zoneId;
            IsolationLevel level = MySqlConnection.convertIsolationLevel((String)row.get(0, String.class));
            long lockWaitTimeout = MySqlConnection.convertLockWaitTimeout((Long)row.get(1, Long.class));
            String product = (String)row.get(2, String.class);
            String systemTimeZone = (String)row.get(3, String.class);
            String timeZone = (String)row.get(4, String.class);
            if (timeZone == null || timeZone.isEmpty() || "SYSTEM".equalsIgnoreCase(timeZone)) {
                if (systemTimeZone == null || systemTimeZone.isEmpty()) {
                    logger.warn("MySQL does not return any timezone, trying to use system default timezone");
                    zoneId = ZoneId.systemDefault();
                } else {
                    zoneId = MySqlConnection.convertZoneId(systemTimeZone);
                }
            } else {
                zoneId = MySqlConnection.convertZoneId(timeZone);
            }
            return new InitData(level, lockWaitTimeout, product, zoneId);
        });
    }

    private static ZoneId convertZoneId(String id) {
        String realId = id.startsWith(ZONE_PREFIX_POSIX) || id.startsWith(ZONE_PREFIX_RIGHT) ? id.substring(6) : id;
        try {
            switch (realId) {
                case "Factory": {
                    return ZoneOffset.UTC;
                }
                case "America/Nuuk": {
                    return ZoneId.of("America/Godthab");
                }
                case "ROC": {
                    return ZoneId.of("+8");
                }
            }
            return ZoneId.of(realId, ZoneId.SHORT_IDS);
        }
        catch (DateTimeException e) {
            logger.warn("The server timezone is unknown <{}>, trying to use system default timezone", (Object)id, (Object)e);
            return ZoneId.systemDefault();
        }
    }

    private static IsolationLevel convertIsolationLevel(@Nullable String name) {
        if (name == null) {
            logger.warn("Isolation level is null in current session, fallback to repeatable read");
            return IsolationLevel.REPEATABLE_READ;
        }
        switch (name) {
            case "READ-UNCOMMITTED": {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case "READ-COMMITTED": {
                return IsolationLevel.READ_COMMITTED;
            }
            case "REPEATABLE-READ": {
                return IsolationLevel.REPEATABLE_READ;
            }
            case "SERIALIZABLE": {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        logger.warn("Unknown isolation level {} in current session, fallback to repeatable read", (Object)name);
        return IsolationLevel.REPEATABLE_READ;
    }

    private static long convertLockWaitTimeout(@Nullable Long timeout) {
        if (timeout == null) {
            logger.error("Lock wait timeout is null, fallback to 50 seconds");
            return 50L;
        }
        return timeout;
    }

    private static String transactionIsolationColumn(ConnectionContext context) {
        ServerVersion version = context.getServerVersion();
        if (context.isMariaDb()) {
            return version.isGreaterThanOrEqualTo(MARIA_11_1_1) ? "@@transaction_isolation AS i" : "@@tx_isolation AS i";
        }
        return version.isGreaterThanOrEqualTo(MYSQL_8_0_3) || version.isGreaterThanOrEqualTo(MYSQL_5_7_20) && version.isLessThan(MYSQL_8) ? "@@transaction_isolation AS i" : "@@tx_isolation AS i";
    }

    private static class InitData {
        private final IsolationLevel level;
        private final long lockWaitTimeout;
        @Nullable
        private final String product;
        @Nullable
        private final ZoneId serverZoneId;

        private InitData(IsolationLevel level, long lockWaitTimeout, @Nullable String product, @Nullable ZoneId serverZoneId) {
            this.level = level;
            this.lockWaitTimeout = lockWaitTimeout;
            this.product = product;
            this.serverZoneId = serverZoneId;
        }
    }
}

