/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.ConnectionState;
import reactor.core.publisher.SynchronousSink;

final class CommitRollbackState
extends AbstractTransactionState {
    private static final int LOCK_WAIT_TIMEOUT = 1;
    private static final int COMMIT_OR_ROLLBACK = 2;
    private static final int CANCEL = 4;
    private final boolean commit;

    CommitRollbackState(ConnectionState state, boolean commit) {
        super(state);
        this.commit = commit;
    }

    @Override
    boolean cancelTasks() {
        if (!this.state.isInTransaction()) {
            this.tasks |= 4;
            return true;
        }
        if (this.state.isLockWaitTimeoutChanged()) {
            this.tasks |= 1;
            this.statements.add("SET innodb_lock_wait_timeout=" + this.state.getSessionLockWaitTimeout());
        }
        this.tasks |= 2;
        String doneSql = this.commit ? "COMMIT" : "ROLLBACK";
        this.statements.add(doneSql);
        return false;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                this.state.resetCurrentLockWaitTimeout();
                return true;
            }
            case 2: {
                this.state.resetIsolationLevel();
                sink.complete();
                return false;
            }
            case 4: {
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined commit task: " + task + ", remain: " + this.tasks));
        return false;
    }
}

