/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

public final class TextQueryMessage
implements ClientMessage {
    static final byte QUERY_FLAG = 3;
    private final String sql;

    public TextQueryMessage(String sql) {
        AssertUtils.requireNonNull(sql, "sql must not be null");
        this.sql = sql;
    }

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        Charset charset = context.getClientCollation().getCharset();
        return Mono.fromSupplier(() -> {
            ByteBuf buf = allocator.buffer();
            try {
                buf.writeByte(3).writeCharSequence((CharSequence)this.sql, charset);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }

    public String toString() {
        return "TextQueryMessage{sql=REDACTED}";
    }
}

