/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.asyncer.r2dbc.mysql.message.server.WarningMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public final class OkMessage
implements WarningMessage,
ServerStatusMessage,
CompleteMessage {
    private static final int MIN_SIZE = 7;
    private final long affectedRows;
    private final long lastInsertId;
    private final short serverStatuses;
    private final int warnings;
    private final String information;

    private OkMessage(long affectedRows, long lastInsertId, short serverStatuses, int warnings, String information) {
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.serverStatuses = serverStatuses;
        this.warnings = warnings;
        this.information = AssertUtils.requireNonNull(information, "information must not be null");
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isDone() {
        return (this.serverStatuses & 8) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OkMessage)) {
            return false;
        }
        OkMessage okMessage = (OkMessage)o;
        return this.affectedRows == okMessage.affectedRows && this.lastInsertId == okMessage.lastInsertId && this.serverStatuses == okMessage.serverStatuses && this.warnings == okMessage.warnings && this.information.equals(okMessage.information);
    }

    public int hashCode() {
        int result = (int)(this.affectedRows ^ this.affectedRows >>> 32);
        result = 31 * result + (int)(this.lastInsertId ^ this.lastInsertId >>> 32);
        result = 31 * result + this.serverStatuses;
        result = 31 * result + this.warnings;
        return 31 * result + this.information.hashCode();
    }

    public String toString() {
        if (this.warnings == 0) {
            return "OkMessage{affectedRows=" + this.affectedRows + ", lastInsertId=" + this.lastInsertId + ", serverStatuses=" + Integer.toHexString(this.serverStatuses) + ", information='" + this.information + "'}";
        }
        return "OkMessage{affectedRows=" + this.affectedRows + ", lastInsertId=" + this.lastInsertId + ", serverStatuses=" + Integer.toHexString(this.serverStatuses) + ", warnings=" + this.warnings + ", information='" + this.information + "'}";
    }

    static boolean isValidSize(int bytes) {
        return bytes >= 7;
    }

    static OkMessage decode(ByteBuf buf, ConnectionContext context) {
        int warnings;
        short serverStatuses;
        buf.skipBytes(1);
        Capability capability = context.getCapability();
        long affectedRows = VarIntUtils.readVarInt(buf);
        long lastInsertId = VarIntUtils.readVarInt(buf);
        if (capability.isProtocol41()) {
            serverStatuses = buf.readShortLE();
            warnings = buf.readUnsignedShortLE();
        } else if (capability.isTransactionAllowed()) {
            serverStatuses = buf.readShortLE();
            warnings = 0;
        } else {
            serverStatuses = 0;
            warnings = 0;
        }
        if (buf.isReadable()) {
            Charset charset = context.getClientCollation().getCharset();
            int sizeAfterVarInt = VarIntUtils.checkNextVarInt(buf);
            if (sizeAfterVarInt < 0) {
                return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, buf.toString(charset));
            }
            int readerIndex = buf.readerIndex();
            long size = VarIntUtils.readVarInt(buf);
            String information = size > (long)sizeAfterVarInt ? buf.toString(readerIndex, buf.writerIndex() - readerIndex, charset) : buf.toString(buf.readerIndex(), (int)size, charset);
            return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, information);
        }
        return new OkMessage(affectedRows, lastInsertId, serverStatuses, warnings, "");
    }
}

