/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.message.server.HandshakeHeader;
import io.asyncer.r2dbc.mysql.message.server.HandshakeRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;

final class HandshakeV9Request
implements HandshakeRequest {
    private static final Capability SERVER_CAPABILITY = Capability.of(0);
    private final HandshakeHeader header;
    private final int envelopeId;
    private final byte[] salt;

    private HandshakeV9Request(HandshakeHeader header, int envelopeId, byte[] salt) {
        this.header = AssertUtils.requireNonNull(header, "header must not be null");
        this.envelopeId = envelopeId;
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
    }

    @Override
    public HandshakeHeader getHeader() {
        return this.header;
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    @Override
    public Capability getServerCapability() {
        return SERVER_CAPABILITY;
    }

    @Override
    public String getAuthType() {
        return "mysql_old_password";
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandshakeV9Request that = (HandshakeV9Request)o;
        return this.envelopeId == that.envelopeId && this.header.equals(that.header) && Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        int hash = 31 * this.header.hashCode() + this.envelopeId;
        return 31 * hash + Arrays.hashCode(this.salt);
    }

    public String toString() {
        return "HandshakeV9Request{header=" + this.header + ", envelopeId=" + this.envelopeId + ", salt=REDACTED}";
    }

    static HandshakeV9Request decode(int envelopeId, ByteBuf buf, HandshakeHeader header) {
        int bytes = buf.readableBytes();
        if (bytes <= 0) {
            return new HandshakeV9Request(header, envelopeId, InternalArrays.EMPTY_BYTES);
        }
        byte[] salt = buf.getByte(buf.writerIndex() - 1) == 0 ? ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)(bytes - 1)) : ByteBufUtil.getBytes((ByteBuf)buf);
        return new HandshakeV9Request(header, envelopeId, salt);
    }
}

