/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.internal.util.NettyBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.util.List;

final class ByteBufCombiner {
    static ByteBuf composite(List<ByteBuf> parts) {
        int size = parts.size();
        switch (size) {
            case 0: {
                throw new IllegalStateException("No buffer available");
            }
            case 1: {
                try {
                    ByteBuf byteBuf = parts.get(0);
                    return byteBuf;
                }
                finally {
                    parts.clear();
                }
            }
        }
        CompositeByteBuf composite = null;
        try {
            composite = parts.get(0).alloc().compositeBuffer(size);
            CompositeByteBuf compositeByteBuf = composite.addComponents(true, parts);
            return compositeByteBuf;
        }
        catch (Throwable e) {
            if (composite == null) {
                NettyBufferUtils.releaseAll(parts);
            } else {
                composite.release();
            }
            throw e;
        }
        finally {
            parts.clear();
        }
    }

    private ByteBufCombiner() {
    }
}

