/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

abstract class SizedClientMessage
implements ClientMessage {
    SizedClientMessage() {
    }

    protected abstract int size();

    protected abstract void writeTo(ByteBuf var1);

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf buf = allocator.buffer(this.size());
            try {
                this.writeTo(buf);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }
}

