/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.message.client.SizedClientMessage;
import io.netty.buffer.ByteBuf;

public final class PreparedFetchMessage
extends SizedClientMessage {
    private static final int SIZE = 9;
    private static final byte FETCH_FLAG = 28;
    private final int statementId;
    private final int fetchSize;

    public PreparedFetchMessage(int statementId, int fetchSize) {
        this.statementId = statementId;
        this.fetchSize = fetchSize;
    }

    @Override
    protected int size() {
        return 9;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeByte(28).writeIntLE(this.statementId).writeIntLE(this.fetchSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreparedFetchMessage)) {
            return false;
        }
        PreparedFetchMessage that = (PreparedFetchMessage)o;
        return this.statementId == that.statementId && this.fetchSize == that.fetchSize;
    }

    public int hashCode() {
        return 31 * this.statementId + this.fetchSize;
    }

    public String toString() {
        return "PreparedFetchMessage{statementId=" + this.statementId + ", fetchSize=" + Integer.toUnsignedLong(this.fetchSize) + '}';
    }
}

