/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.ParametrizedCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import reactor.core.publisher.Mono;

final class SetCodec
implements ParametrizedCodec<String[]> {
    private final ByteBufAllocator allocator;

    SetCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public String[] decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return InternalArrays.EMPTY_STRINGS;
        }
        int firstComma = value.indexOf(value.readerIndex(), value.writerIndex(), (byte)44);
        Charset charset = metadata.getCharCollation(context).getCharset();
        if (firstComma < 0) {
            return new String[]{value.toString(charset)};
        }
        return value.toString(charset).split(",");
    }

    @Override
    public Set<?> decode(ByteBuf value, MySqlColumnMetadata metadata, ParameterizedType target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return Collections.emptySet();
        }
        Class subClass = (Class)target.getActualTypeArguments()[0];
        Charset charset = metadata.getCharCollation(context).getCharset();
        int firstComma = value.indexOf(value.readerIndex(), value.writerIndex(), (byte)44);
        boolean isEnum = subClass.isEnum();
        if (firstComma < 0) {
            if (isEnum) {
                return Collections.singleton(Enum.valueOf(subClass, value.toString(charset)));
            }
            return Collections.singleton(value.toString(charset));
        }
        SplitIterable elements = new SplitIterable(value, charset, firstComma);
        Set<?> result = SetCodec.buildSet(subClass, isEnum);
        if (isEnum) {
            Class enumClass = subClass;
            Set<?> enumSet = result;
            for (String element : elements) {
                enumSet.add(Enum.valueOf(enumClass, element));
            }
        } else {
            for (String element : elements) {
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return metadata.getType() == MySqlType.SET && target.isAssignableFrom(String[].class);
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, ParameterizedType target) {
        if (metadata.getType() != MySqlType.SET) {
            return false;
        }
        Class<String> argument = CodecUtils.getTypeArgument(target, Set.class);
        return argument != null && (argument.isEnum() || argument.isAssignableFrom(String.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof CharSequence[] || value instanceof Set && SetCodec.isValidSet((Set)value);
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        if (value instanceof CharSequence[]) {
            return new StringArrayMySqlParameter(this.allocator, InternalArrays.toImmutableList((CharSequence[])value), context);
        }
        return new SetMySqlParameter(this.allocator, (Set)value, context);
    }

    private static Set<?> buildSet(Class<?> subClass, boolean isEnum) {
        if (isEnum) {
            EnumSet<?> s = EnumSet.noneOf(subClass);
            return s;
        }
        return new LinkedHashSet();
    }

    private static boolean isValidSet(Set<?> value) {
        for (Object element : value) {
            if (element instanceof CharSequence || element instanceof Enum) continue;
            return false;
        }
        return true;
    }

    private static void encodeIterator(ParameterWriter writer, Iterator<? extends CharSequence> iter) {
        if (iter.hasNext()) {
            writer.append(iter.next());
            while (iter.hasNext()) {
                writer.append(',').append(iter.next());
            }
        } else {
            writer.startString();
        }
    }

    private static ByteBuf encodeSet(ByteBufAllocator alloc, Iterator<? extends CharSequence> iter, CodecContext context) {
        Charset charset = context.getClientCollation().getCharset();
        ByteBuf content = alloc.buffer();
        try {
            VarIntUtils.reserveVarInt(content);
            CharSequence name = iter.next();
            int size = content.writeCharSequence(name, charset);
            while (iter.hasNext()) {
                name = iter.next();
                size += content.writeByte(44).writeCharSequence(name, charset) + 1;
            }
            return VarIntUtils.setReservedVarInt(content, size);
        }
        catch (Throwable e) {
            content.release();
            throw e;
        }
    }

    private static final class StringArrayMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final List<CharSequence> value;
        private final CodecContext context;

        private StringArrayMySqlParameter(ByteBufAllocator allocator, List<CharSequence> value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                if (this.value.isEmpty()) {
                    return this.allocator.buffer(1).writeByte(0);
                }
                return SetCodec.encodeSet(this.allocator, this.value.iterator(), this.context);
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> SetCodec.encodeIterator(writer, this.value.iterator()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringArrayMySqlParameter)) {
                return false;
            }
            StringArrayMySqlParameter that = (StringArrayMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class SetMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final Set<?> value;
        private final CodecContext context;

        private SetMySqlParameter(ByteBufAllocator allocator, Set<?> value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                if (this.value.isEmpty()) {
                    return this.allocator.buffer(1).writeByte(0);
                }
                return SetCodec.encodeSet(this.allocator, new ConvertedIterator(this.value.iterator()), this.context);
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> SetCodec.encodeIterator(writer, new ConvertedIterator(this.value.iterator())));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetMySqlParameter)) {
                return false;
            }
            SetMySqlParameter setValue = (SetMySqlParameter)o;
            return this.value.equals(setValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class ConvertedIterator
    implements Iterator<String> {
        private final Iterator<?> origin;

        private ConvertedIterator(Iterator<?> origin) {
            this.origin = origin;
        }

        @Override
        public boolean hasNext() {
            return this.origin.hasNext();
        }

        @Override
        public String next() {
            Object o = this.origin.next();
            return o instanceof Enum ? ((Enum)o).name() : o.toString();
        }
    }

    private static final class SplitIterator
    implements Iterator<String> {
        private final ByteBuf buf;
        private final Charset charset;
        private int lastChar;
        private int currentComma;
        private final int writerIndex;

        SplitIterator(ByteBuf buf, Charset charset, int currentComma) {
            this.buf = buf;
            this.charset = charset;
            this.lastChar = buf.readerIndex();
            this.currentComma = currentComma;
            this.writerIndex = buf.writerIndex();
        }

        @Override
        public boolean hasNext() {
            return this.currentComma <= this.writerIndex && this.currentComma >= this.lastChar;
        }

        @Override
        public String next() {
            int nextStart;
            String result = this.buf.toString(this.lastChar, this.currentComma - this.lastChar, this.charset);
            this.lastChar = nextStart = this.currentComma + 1;
            this.currentComma = this.nextComma(nextStart);
            return result;
        }

        private int nextComma(int nextStart) {
            if (nextStart > this.writerIndex) {
                return nextStart;
            }
            int index = this.buf.indexOf(nextStart, this.writerIndex, (byte)44);
            if (index < 0) {
                return this.writerIndex;
            }
            return index;
        }
    }

    private static final class SplitIterable
    implements Iterable<String> {
        private final ByteBuf buf;
        private final Charset charset;
        private final int firstComma;

        SplitIterable(ByteBuf buf, Charset charset, int firstComma) {
            this.buf = buf;
            this.charset = charset;
            this.firstComma = firstComma < 0 ? buf.writerIndex() : firstComma;
        }

        @Override
        public Iterator<String> iterator() {
            return new SplitIterator(this.buf, this.charset, this.firstComma);
        }
    }
}

