/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.client.ActiveStatus;
import io.asyncer.r2dbc.mysql.client.RequestTask;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;
import reactor.util.concurrent.Queues;

final class RequestQueue
extends ActiveStatus
implements Runnable {
    private final Queue<RequestTask<?>> queue = (Queue)Queues.small().get();
    @Nullable
    private volatile RuntimeException disposed;

    RequestQueue() {
    }

    @Override
    public void run() {
        RequestTask<?> task = this.queue.poll();
        if (task == null) {
            STATUS_UPDATER.compareAndSet(this, 1, 0);
        } else {
            int status = this.status;
            if (status == -1) {
                task.cancel(this.requireDisposed());
            } else {
                task.run();
            }
        }
    }

    <T> void submit(RequestTask<T> task) {
        if (STATUS_UPDATER.compareAndSet(this, 0, 1)) {
            task.run();
            return;
        }
        int status = this.status;
        if (status == -1) {
            task.cancel(this.requireDisposed());
            return;
        }
        if (!this.queue.offer(task)) {
            task.cancel(new IllegalStateException("Request queue is full"));
            return;
        }
        if (STATUS_UPDATER.compareAndSet(this, 0, 1)) {
            this.run();
        } else {
            status = this.status;
            if (status == -1) {
                this.cancelAll(this.requireDisposed());
            }
        }
    }

    long keeping(int v) {
        this.p8 = v;
        this.pe = this.pf = (long)this.p8;
        this.pd = this.pf;
        this.pc = this.pf;
        this.pb = this.pf;
        this.pa = this.pf;
        this.p9 = this.pf;
        this.p7 = this.pf;
        this.p6 = this.pf;
        this.p5 = this.pf;
        this.p4 = this.pf;
        this.p3 = this.pf;
        this.p2 = this.pf;
        this.p1 = this.pf;
        this.p0 = this.pf;
        return this.pf;
    }

    void dispose() {
        STATUS_UPDATER.set(this, -1);
        this.cancelAll(this.requireDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException requireDisposed() {
        RuntimeException disposed = this.disposed;
        if (disposed == null) {
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                disposed = this.disposed;
                if (disposed == null) {
                    this.disposed = disposed = new IllegalStateException("Request queue was disposed");
                }
                return disposed;
            }
        }
        return disposed;
    }

    private void cancelAll(RuntimeException e) {
        RequestTask<?> task;
        while ((task = this.queue.poll()) != null) {
            task.cancel(e);
        }
    }
}

