/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import io.apptik.widget.Util;
import io.apptik.widget.mslider.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultiSlider
extends View {
    private AccessibilityNodeProvider mAccessibilityNodeProvider;
    private OnThumbValueChangeListener mOnThumbValueChangeListener;
    private OnTrackingChangeListener mOnTrackingChangeListener;
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mScaleMin;
    private int mScaleMax;
    private int mStep;
    private int mStepsThumbsApart;
    private boolean mDrawThumbsApart;
    private Drawable mTrack;
    private boolean mNoInvalidate;
    private long mUiThreadId;
    private boolean mInDrawing;
    private boolean mAttached;
    private boolean mRefreshIsPosted;
    boolean mMirrorForRtl = true;
    private LinkedList<Thumb> mThumbs;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha = 0.5f;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private List<Thumb> mDraggingThumbs = new LinkedList<Thumb>();
    LinkedList<Thumb> exactTouched = null;
    private Drawable defThumbDrawable;
    private int defThumbColor = 0;
    private Drawable defRangeDrawable;
    private int defRangeColor = 0;
    private final TypedArray a;

    public MultiSlider(Context context) {
        this(context, null);
    }

    public MultiSlider(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.multiSliderStyle);
    }

    public MultiSlider(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public MultiSlider(Context context, AttributeSet attrs, int defStyle, int styleRes) {
        super(context, attrs, defStyle);
        if (Build.VERSION.SDK_INT >= 21 && this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.control_background_multi_material);
        }
        this.mUiThreadId = Thread.currentThread().getId();
        this.a = context.obtainStyledAttributes(attrs, R.styleable.MultiSlider, defStyle, styleRes);
        this.mNoInvalidate = true;
        int numThumbs = this.a.getInt(R.styleable.MultiSlider_thumbNumber, 2);
        this.initMultiSlider(numThumbs);
        Drawable trackDrawable = this.a.getDrawable(R.styleable.MultiSlider_android_track);
        if (trackDrawable == null) {
            trackDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.multislider_track_material);
        }
        this.setTrackDrawable(this.getTintedDrawable(trackDrawable, this.a.getColor(R.styleable.MultiSlider_trackColor, 0)));
        this.setStep(this.a.getInt(R.styleable.MultiSlider_scaleStep, this.mStep));
        this.setStepsThumbsApart(this.a.getInt(R.styleable.MultiSlider_stepsThumbsApart, this.mStepsThumbsApart));
        this.setDrawThumbsApart(this.a.getBoolean(R.styleable.MultiSlider_drawThumbsApart, this.mDrawThumbsApart));
        this.setMax(this.a.getInt(R.styleable.MultiSlider_scaleMax, this.mScaleMax), true);
        this.setMin(this.a.getInt(R.styleable.MultiSlider_scaleMin, this.mScaleMin), true);
        this.mMirrorForRtl = this.a.getBoolean(R.styleable.MultiSlider_mirrorForRTL, this.mMirrorForRtl);
        this.defThumbDrawable = this.a.getDrawable(R.styleable.MultiSlider_android_thumb);
        if (this.defThumbDrawable == null) {
            this.defThumbDrawable = Build.VERSION.SDK_INT >= 21 ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.multislider_thumb_material_anim) : ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.multislider_thumb_material);
        }
        this.defRangeDrawable = this.a.getDrawable(R.styleable.MultiSlider_range);
        if (this.defRangeDrawable == null) {
            this.defRangeDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.multislider_range_material);
        }
        Drawable range1Drawable = this.a.getDrawable(R.styleable.MultiSlider_range1);
        Drawable range2Drawable = this.a.getDrawable(R.styleable.MultiSlider_range2);
        this.defRangeColor = this.a.getColor(R.styleable.MultiSlider_rangeColor, 0);
        this.defThumbColor = this.a.getColor(R.styleable.MultiSlider_thumbColor, 0);
        this.setThumbDrawables(this.defThumbDrawable, this.defRangeDrawable, range1Drawable, range2Drawable);
        int thumbOffset = this.a.getDimensionPixelOffset(R.styleable.MultiSlider_android_thumbOffset, this.defThumbDrawable.getIntrinsicWidth() / 2);
        this.setThumbOffset(thumbOffset);
        this.repositionThumbs();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mNoInvalidate = false;
        this.a.recycle();
    }

    public int getStepsThumbsApart() {
        return this.mStepsThumbsApart;
    }

    public void setStepsThumbsApart(int stepsThumbsApart) {
        if (stepsThumbsApart < 0) {
            stepsThumbsApart = 0;
        }
        this.mStepsThumbsApart = stepsThumbsApart;
    }

    public int getStep() {
        return this.mStep;
    }

    public void setStep(int mStep) {
        this.mStep = mStep;
    }

    public int getScaleSize() {
        return this.mScaleMax - this.mScaleMin;
    }

    public void repositionThumbs() {
        if (this.mThumbs == null || this.mThumbs.isEmpty()) {
            return;
        }
        if (this.mThumbs.size() > 0) {
            this.mThumbs.getFirst().setValue(this.mScaleMin);
        }
        if (this.mThumbs.size() > 1) {
            this.mThumbs.getLast().setValue(this.mScaleMax);
        }
        if (this.mThumbs.size() > 2) {
            int even = (this.mScaleMax - this.mScaleMin) / (this.mThumbs.size() - 1);
            int lastPos = this.mScaleMax - even;
            for (int i = this.mThumbs.size() - 2; i > 0; --i) {
                this.mThumbs.get(i).setValue(lastPos);
                lastPos -= even;
            }
        }
    }

    public void setOnThumbValueChangeListener(OnThumbValueChangeListener l) {
        this.mOnThumbValueChangeListener = l;
    }

    public void setOnTrackingChangeListener(OnTrackingChangeListener l) {
        this.mOnTrackingChangeListener = l;
    }

    public boolean isDrawThumbsApart() {
        return this.mDrawThumbsApart;
    }

    public void setDrawThumbsApart(boolean drawThumbsApart) {
        this.mDrawThumbsApart = drawThumbsApart;
    }

    private void initMultiSlider(int numThumbs) {
        this.mStep = 1;
        this.mStepsThumbsApart = 0;
        this.mDrawThumbsApart = false;
        this.mScaleMin = 0;
        this.mScaleMax = 100;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
        this.mThumbs = new LinkedList();
        for (int i = 0; i < numThumbs; ++i) {
            this.mThumbs.add(new Thumb().setMin(this.mScaleMin).setMax(this.mScaleMax).setTag("thumb " + i));
        }
    }

    public MultiSlider setNumberOfThumbs(int numThumbs) {
        return this.setNumberOfThumbs(numThumbs, true);
    }

    public MultiSlider setNumberOfThumbs(int numThumbs, boolean repositon) {
        this.clearThumbs();
        for (int i = 0; i < numThumbs; ++i) {
            this.addThumb(0);
        }
        if (repositon) {
            this.repositionThumbs();
        }
        return this;
    }

    public boolean addThumb(Thumb thumb) {
        return this.addThumbOnPos(thumb, this.mThumbs.size());
    }

    public boolean addThumbOnPos(Thumb thumb, int pos) {
        if (this.mThumbs.contains(thumb)) {
            return false;
        }
        if (thumb.getThumb() == null) {
            this.setThumbDrawable(thumb, this.defThumbDrawable, this.defThumbColor);
        }
        int paddingLeft = Math.max(this.getPaddingLeft(), thumb.getThumbOffset());
        int paddingRight = Math.max(this.getPaddingRight(), thumb.getThumbOffset());
        this.setPadding(paddingLeft, this.getPaddingTop(), paddingRight, this.getPaddingBottom());
        if (thumb.getRange() == null) {
            this.setRangeDrawable(thumb, this.defRangeDrawable, this.defRangeColor);
        }
        this.mThumbs.add(pos, thumb);
        this.setThumbValue(thumb, thumb.value, false);
        return true;
    }

    public Thumb addThumb(int value) {
        Thumb thumb = new Thumb();
        this.addThumb(thumb);
        thumb.setValue(value);
        return thumb;
    }

    public Thumb addThumb() {
        Thumb thumb = new Thumb();
        this.addThumb(thumb);
        return thumb;
    }

    public Thumb addThumbOnPos(int pos, int value) {
        Thumb thumb = new Thumb();
        this.addThumbOnPos(thumb, pos);
        thumb.setValue(value);
        return thumb;
    }

    public Thumb addThumbOnPos(int pos) {
        Thumb thumb = new Thumb();
        this.addThumbOnPos(thumb, pos);
        return thumb;
    }

    public boolean removeThumb(Thumb thumb) {
        this.mDraggingThumbs.remove(thumb);
        boolean res = this.mThumbs.remove(thumb);
        this.invalidate();
        return res;
    }

    public Thumb removeThumb(int thumbIndex) {
        this.mDraggingThumbs.remove(this.mThumbs.get(thumbIndex));
        this.invalidate();
        Thumb res = this.mThumbs.remove(thumbIndex);
        this.invalidate();
        return res;
    }

    public void clearThumbs() {
        this.mThumbs.clear();
        this.mDraggingThumbs.clear();
        this.invalidate();
    }

    public void setThumbOffset(int thumbOffset) {
        for (Thumb thumb : this.mThumbs) {
            thumb.setThumbOffset(thumbOffset);
        }
        this.invalidate();
    }

    public void setTrackDrawable(Drawable d) {
        boolean needUpdate;
        if (this.mTrack != null && d != this.mTrack) {
            this.mTrack.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
            int drawableHeight = d.getMinimumHeight();
            if (this.mMaxHeight < drawableHeight) {
                this.mMaxHeight = drawableHeight;
                this.requestLayout();
            }
        }
        this.mTrack = d;
        if (needUpdate) {
            this.updateTrackBounds(this.getWidth(), this.getHeight());
            this.updateTrackState();
        }
    }

    private int optThumbValue(Thumb thumb, int value) {
        if (thumb == null || thumb.getThumb() == null) {
            return value;
        }
        int currIdx = this.mThumbs.indexOf(thumb);
        if (this.mThumbs.size() > currIdx + 1 && value > this.mThumbs.get(currIdx + 1).getValue() - this.mStepsThumbsApart * this.mStep) {
            value = this.mThumbs.get(currIdx + 1).getValue() - this.mStepsThumbsApart * this.mStep;
        }
        if (currIdx > 0 && value < this.mThumbs.get(currIdx - 1).getValue() + this.mStepsThumbsApart * this.mStep) {
            value = this.mThumbs.get(currIdx - 1).getValue() + this.mStepsThumbsApart * this.mStep;
        }
        if ((value - this.mScaleMin) % this.mStep != 0) {
            value += this.mStep - (value - this.mScaleMin) % this.mStep;
        }
        if (value < thumb.getMin()) {
            value = thumb.getMin();
        }
        if (value > thumb.getMax()) {
            value = thumb.getMax();
        }
        return value;
    }

    private synchronized void setThumbValue(Thumb thumb, int value, boolean fromUser) {
        if (thumb == null || thumb.getThumb() == null) {
            return;
        }
        if ((value = this.optThumbValue(thumb, value)) != thumb.getValue()) {
            thumb.value = value;
        }
        if (this.hasOnThumbValueChangeListener()) {
            this.mOnThumbValueChangeListener.onValueChanged(this, thumb, this.mThumbs.indexOf(thumb), thumb.getValue());
        }
        this.updateThumb(thumb, this.getWidth(), this.getHeight());
    }

    private synchronized void setThumbValue(int thumb, int value, boolean fromUser) {
        this.setThumbValue(this.mThumbs.get(thumb), value, fromUser);
    }

    private void updateTrackBounds(int w, int h) {
        int right = w -= this.getPaddingRight() + this.getPaddingLeft();
        int bottom = h -= this.getPaddingTop() + this.getPaddingBottom();
        boolean top = false;
        boolean left = false;
        if (this.mTrack != null) {
            this.mTrack.setBounds(0, 0, right, bottom);
        }
    }

    private void updateTrackState() {
        int[] state = this.getDrawableState();
        if (this.mTrack != null && this.mTrack.isStateful()) {
            this.mTrack.setState(state);
        }
    }

    private void setThumbDrawables(Drawable thumb, Drawable range, Drawable range1, Drawable range2) {
        if (thumb == null) {
            return;
        }
        int curr = 0;
        int padding = 0;
        for (Thumb mThumb : this.mThumbs) {
            int rCol;
            Drawable rangeDrawable;
            ++curr;
            if (mThumb.getThumb() != null && thumb != mThumb.getThumb()) {
                mThumb.getThumb().setCallback(null);
            }
            if (curr == 1 && range1 != null) {
                rangeDrawable = range1;
                rCol = this.a.getColor(R.styleable.MultiSlider_range1Color, 0);
            } else if (curr == 2 && range2 != null) {
                rangeDrawable = range2;
                rCol = this.a.getColor(R.styleable.MultiSlider_range2Color, 0);
            } else {
                rangeDrawable = range;
                rCol = this.defRangeColor;
            }
            this.setRangeDrawable(mThumb, rangeDrawable, rCol);
            this.setThumbDrawable(mThumb, thumb, this.defThumbColor);
            padding = Math.max(padding, mThumb.getThumbOffset());
        }
        this.setPadding(padding, this.getPaddingTop(), padding, this.getPaddingBottom());
    }

    private void setThumbDrawable(Thumb thumb, Drawable thumbDrawable, int thumbColor) {
        Util.requireNonNull(thumbDrawable);
        Drawable nThumbDrawable = this.getTintedDrawable(thumbDrawable.getConstantState().newDrawable(), thumbColor);
        nThumbDrawable.setCallback((Drawable.Callback)this);
        thumb.setThumbOffset(thumbDrawable.getIntrinsicWidth() / 2);
        if (thumb.getThumb() != null && (nThumbDrawable.getIntrinsicWidth() != thumb.getThumb().getIntrinsicWidth() || nThumbDrawable.getIntrinsicHeight() != thumb.getThumb().getIntrinsicHeight())) {
            this.requestLayout();
        }
        thumb.setThumb(nThumbDrawable);
        this.invalidate();
        if (nThumbDrawable != null && nThumbDrawable.isStateful()) {
            int[] state = this.getDrawableState();
            nThumbDrawable.setState(state);
        }
    }

    private void setRangeDrawable(Thumb thumb, Drawable rangeDrawable, int rangeColor) {
        Util.requireNonNull(rangeDrawable);
        Drawable nRangeDrawable = this.getTintedDrawable(rangeDrawable, rangeColor);
        thumb.setRange(nRangeDrawable);
    }

    public Thumb getThumb(int pos) {
        return this.mThumbs.get(pos);
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public synchronized void setMax(int max) {
        this.setMax(max, true, false);
    }

    public synchronized void setMax(int max, boolean extendMaxForThumbs) {
        this.setMax(max, extendMaxForThumbs, false);
    }

    public synchronized void setMax(int max, boolean extendMaxForThumbs, boolean repositionThumbs) {
        if (max < this.mScaleMin) {
            max = this.mScaleMin;
        }
        if (max != this.mScaleMax) {
            this.mScaleMax = max;
            for (Thumb thumb : this.mThumbs) {
                if (extendMaxForThumbs) {
                    thumb.setMax(max);
                } else if (thumb.getMax() > max) {
                    thumb.setMax(max);
                }
                if (thumb.getValue() <= max) continue;
                this.setThumbValue(thumb, max, false);
            }
            if (repositionThumbs) {
                this.repositionThumbs();
            }
            this.postInvalidate();
        }
        if (this.mKeyProgressIncrement == 0 || this.mScaleMax / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.mScaleMax / 20.0f)));
        }
    }

    public int getMax() {
        return this.mScaleMax;
    }

    public synchronized void setMin(int min) {
        this.setMin(min, true, false);
    }

    public synchronized void setMin(int min, boolean extendMinForThumbs) {
        this.setMin(min, extendMinForThumbs, false);
    }

    public synchronized void setMin(int min, boolean extendMinForThumbs, boolean repositionThumbs) {
        if (min > this.mScaleMax) {
            min = this.mScaleMax;
        }
        if (min != this.mScaleMin) {
            this.mScaleMin = min;
            for (Thumb thumb : this.mThumbs) {
                if (extendMinForThumbs) {
                    thumb.setMin(min);
                } else if (thumb.getMin() < min) {
                    thumb.setMin(min);
                }
                if (thumb.getValue() >= min) continue;
                this.setThumbValue(thumb, min, false);
            }
            if (repositionThumbs) {
                this.repositionThumbs();
            }
            this.postInvalidate();
        }
        if (this.mKeyProgressIncrement == 0 || this.mScaleMax / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.mScaleMax / 20.0f)));
        }
    }

    public int getMin() {
        return this.mScaleMin;
    }

    protected boolean verifyDrawable(Drawable who) {
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || who != thumb.getThumb()) continue;
            return true;
        }
        return who == this.mTrack || super.verifyDrawable(who);
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null) continue;
            thumb.getThumb().jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mDraggingThumbs != null && !this.mDraggingThumbs.isEmpty()) {
            int[] state = this.getDrawableState();
            for (Thumb thumb : this.mDraggingThumbs) {
                if (thumb.getThumb() == null) continue;
                thumb.getThumb().setState(state);
            }
            for (Thumb thumb : this.mThumbs) {
                if (this.mDraggingThumbs.contains(thumb) || thumb.getThumb() == null || !thumb.getThumb().isStateful()) continue;
                if (thumb.isEnabled()) {
                    thumb.getThumb().setState(new int[]{16842910});
                    continue;
                }
                thumb.getThumb().setState(new int[]{-16842910});
            }
        } else {
            for (Thumb thumb : this.mThumbs) {
                if (thumb.getThumb() == null || !thumb.getThumb().isStateful()) continue;
                if (thumb.isEnabled()) {
                    thumb.getThumb().setState(new int[]{16842910});
                    continue;
                }
                thumb.getThumb().setState(new int[]{-16842910});
            }
        }
    }

    private void updateThumb(Thumb thumb, int w, int h) {
        int thumbHeight = thumb == null ? 0 : thumb.getThumb().getIntrinsicHeight();
        int trackHeight = h - this.getPaddingTop() - this.getPaddingBottom();
        float scale = this.getScaleSize() > 0 ? (float)thumb.getValue() / (float)this.getScaleSize() : 0.0f;
        Drawable prevThumb = null;
        int currIdx = this.mThumbs.indexOf(thumb);
        if (currIdx > 0) {
            prevThumb = this.mThumbs.get(currIdx - 1).getThumb();
        }
        if (thumbHeight > trackHeight) {
            if (thumb != null) {
                this.setThumbPos(w, h, thumb.getThumb(), prevThumb, thumb.getRange(), scale, 0, thumb.getThumbOffset(), this.getThumbOptOffset(thumb));
            }
            int gapForCenteringTrack = (thumbHeight - trackHeight) / 2;
            if (this.mTrack != null) {
                this.mTrack.setBounds(0, gapForCenteringTrack, w - this.getPaddingRight() - this.getPaddingLeft(), h - this.getPaddingBottom() - gapForCenteringTrack - this.getPaddingTop());
            }
        } else {
            if (this.mTrack != null) {
                this.mTrack.setBounds(0, 0, w - this.getPaddingRight() - this.getPaddingLeft(), h - this.getPaddingBottom() - this.getPaddingTop());
            }
            int gap = (trackHeight - thumbHeight) / 2;
            if (thumb != null) {
                this.setThumbPos(w, h, thumb.getThumb(), prevThumb, thumb.getRange(), scale, gap, thumb.getThumbOffset(), this.getThumbOptOffset(thumb));
            }
        }
        for (int i = currIdx + 1; i < this.mThumbs.size(); ++i) {
            int gap = (trackHeight - thumbHeight) / 2;
            scale = this.getScaleSize() > 0 ? (float)this.mThumbs.get(i).getValue() / (float)this.getScaleSize() : 0.0f;
            this.setThumbPos(w, h, this.mThumbs.get(i).getThumb(), this.mThumbs.get(i - 1).getThumb(), this.mThumbs.get(i).getRange(), scale, gap, this.mThumbs.get(i).getThumbOffset(), this.getThumbOptOffset(this.mThumbs.get(i)));
        }
    }

    private void setThumbPos(int w, int h, Drawable thumb, Drawable prevThumb, Drawable range, float scale, int gap, int thumbOffset, int optThumbOffset) {
        int bottomBound;
        int topBound;
        int available = this.getAvailable();
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        float scaleOffset = this.getScaleSize() > 0 ? (float)this.mScaleMin / (float)this.getScaleSize() : 0.0f;
        int thumbPos = (int)(scale * (float)available - scaleOffset * (float)available + 0.5f);
        if (gap == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            topBound = oldBounds.top;
            bottomBound = oldBounds.bottom;
        } else {
            topBound = gap;
            bottomBound = gap + thumbHeight;
        }
        int thumbStart = this.isLayoutRtl() && this.mMirrorForRtl ? available - thumbPos + optThumbOffset : thumbPos + optThumbOffset;
        thumb.setBounds(thumbStart, topBound, thumbStart + thumbWidth, bottomBound);
        int bottom = h - this.getPaddingTop() + this.getPaddingBottom();
        int rangeStart = 0;
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            rangeStart = available;
        }
        if (prevThumb != null) {
            rangeStart = prevThumb.getBounds().left;
        }
        if (range != null) {
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                range.setBounds(thumbStart, 0, rangeStart + optThumbOffset, bottom);
            } else {
                range.setBounds(rangeStart, 0, thumbStart, bottom);
            }
        }
        this.invalidate();
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int paddingStart = Build.VERSION.SDK_INT >= 17 ? this.getPaddingStart() : this.getPaddingLeft();
        if (this.mTrack != null) {
            canvas.save();
            canvas.translate((float)paddingStart, (float)this.getPaddingTop());
            this.mTrack.draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getRange() == null) continue;
            canvas.save();
            canvas.translate((float)paddingStart, (float)this.getPaddingTop());
            thumb.getRange().draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || thumb.isInvisibleThumb()) continue;
            canvas.save();
            canvas.translate((float)(paddingStart - thumb.getThumbOffset()), (float)this.getPaddingTop());
            thumb.getThumb().draw(canvas);
            canvas.restore();
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxThumbHeight = 0;
        int maxRangeHeight = 0;
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null) continue;
            maxThumbHeight = Math.max(thumb.getThumb().getIntrinsicHeight(), maxThumbHeight);
            maxRangeHeight = Math.max(thumb.getThumb().getIntrinsicHeight(), maxRangeHeight);
        }
        int dw = 0;
        int dh = 0;
        if (this.mTrack != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, this.mTrack.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, this.mTrack.getIntrinsicHeight()));
            dh = Math.max(maxRangeHeight, dh);
            dh = Math.max(maxThumbHeight, dh);
        }
        this.setMeasuredDimension(MultiSlider.resolveSizeAndState((int)(dw += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)0), MultiSlider.resolveSizeAndState((int)(dh += this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec, (int)0));
    }

    public boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    private int getAvailable() {
        int available = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        if (this.mThumbs != null && this.mThumbs.size() > 0) {
            available = this.isLayoutRtl() && this.mMirrorForRtl ? (available -= this.getThumbOptOffset(this.mThumbs.getFirst())) : (available -= this.getThumbOptOffset(this.mThumbs.getLast()));
        }
        return available;
    }

    private LinkedList<Thumb> getClosestThumb(int x) {
        LinkedList<Thumb> exact = new LinkedList<Thumb>();
        Thumb closest = null;
        int currDistance = this.getAvailable() + 1;
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || !thumb.isEnabled() || this.mDraggingThumbs.contains(thumb)) continue;
            int minV = x - thumb.getThumb().getIntrinsicWidth();
            int maxV = x + thumb.getThumb().getIntrinsicWidth();
            if (thumb.getThumb().getBounds().centerX() >= minV && thumb.getThumb().getBounds().centerX() <= maxV) {
                exact.add(thumb);
                continue;
            }
            if (Math.abs(thumb.getThumb().getBounds().centerX() - x) > currDistance) continue;
            if (Math.abs(thumb.getThumb().getBounds().centerX() - x) == currDistance) {
                if (x <= this.getWidth() / 2) continue;
                closest = thumb;
                continue;
            }
            if (thumb.getThumb() == null) continue;
            currDistance = Math.abs(thumb.getThumb().getBounds().centerX() - x);
            closest = thumb;
        }
        if (exact.isEmpty() && closest != null) {
            exact.add(closest);
        }
        return exact;
    }

    private Thumb getMostMovable(LinkedList<Thumb> thumbs, MotionEvent event) {
        Thumb res = null;
        int maxChange = 0;
        if (thumbs != null && !thumbs.isEmpty()) {
            if (thumbs.getFirst().getValue() == this.getValue(event, thumbs.getFirst())) {
                return null;
            }
            for (Thumb thumb : thumbs) {
                int optValue;
                if (thumb.getThumb() == null || !thumb.isEnabled() || this.mDraggingThumbs.contains(thumb)) continue;
                int n = optValue = this.getValue(event, thumbs.getFirst()) > thumb.getValue() ? this.mScaleMax : this.mScaleMin;
                int currChange = Math.abs(thumb.getValue() - this.optThumbValue(thumb, optValue));
                if (currChange <= maxChange) continue;
                maxChange = currChange;
                res = thumb;
            }
        }
        return res;
    }

    private Thumb getMostMovableThumb(MotionEvent event) {
        if (this.exactTouched == null || this.exactTouched.size() < 1) {
            return null;
        }
        if (this.exactTouched.size() == 1) {
            return this.exactTouched.getFirst();
        }
        return this.getMostMovable(this.exactTouched, event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        int xx = Math.round(event.getX());
        int yy = Math.round(event.getY());
        int pointerIdx = event.getActionIndex();
        Thumb currThumb = null;
        if (event.getActionMasked() == 0 || event.getActionMasked() == 5) {
            LinkedList<Thumb> closestOnes = this.getClosestThumb((int)event.getX(pointerIdx));
            if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0 && this.exactTouched != null && pointerIdx > 0) {
                Thumb prevThumb = this.exactTouched.getFirst();
                this.onStartTrackingTouch(prevThumb);
                this.exactTouched = null;
            }
            if (closestOnes != null && !closestOnes.isEmpty()) {
                if (closestOnes.size() == 1) {
                    currThumb = closestOnes.getFirst();
                    if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                        this.exactTouched = closestOnes;
                    }
                } else {
                    this.exactTouched = closestOnes;
                }
            }
        } else if (event.getActionMasked() == 2) {
            if (this.exactTouched != null && !this.exactTouched.isEmpty()) {
                currThumb = this.getMostMovableThumb(event);
            } else if (this.mDraggingThumbs.size() > pointerIdx) {
                currThumb = this.mDraggingThumbs.get(pointerIdx);
            }
        } else if (event.getActionMasked() == 1 || event.getActionMasked() == 6) {
            if (this.mDraggingThumbs.size() > pointerIdx) {
                currThumb = this.mDraggingThumbs.get(pointerIdx);
            } else if (this.exactTouched != null && this.exactTouched.size() > 0) {
                currThumb = this.getMostMovableThumb(event);
                this.exactTouched = null;
            }
        }
        switch (event.getActionMasked()) {
            case 0: 
            case 5: {
                if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                    this.mTouchDownX = event.getX(pointerIdx);
                    break;
                }
                this.onStartTrackingTouch(currThumb);
                this.setThumbValue(currThumb, this.getValue(event, currThumb), true);
                this.setHotspot(xx, yy, currThumb);
                break;
            }
            case 2: {
                if (this.mDraggingThumbs.contains(currThumb)) {
                    for (int i = 0; i < this.mDraggingThumbs.size(); ++i) {
                        if (this.mDraggingThumbs.get(i) != null && this.mDraggingThumbs.get(i).getThumb() != null) {
                            this.invalidate(this.mDraggingThumbs.get(i).getThumb().getBounds());
                        }
                        this.setThumbValue(this.mDraggingThumbs.get(i), this.getValue(event, i, this.mDraggingThumbs.get(i)), true);
                    }
                    this.setHotspot(xx, yy, currThumb);
                    break;
                }
                float x = event.getX(pointerIdx);
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.onStartTrackingTouch(currThumb);
                this.exactTouched = null;
                this.setThumbValue(currThumb, this.getValue(event, currThumb), true);
                this.setHotspot(xx, yy, currThumb);
                break;
            }
            case 1: {
                this.setPressed(false);
            }
            case 6: {
                if (currThumb != null) {
                    this.setThumbValue(currThumb, this.getValue(event, currThumb), true);
                    this.setHotspot(xx, yy, currThumb);
                    boolean toUnPress = false;
                    if (!this.isPressed()) {
                        this.setPressed(true);
                        toUnPress = true;
                    }
                    this.onStopTrackingTouch(currThumb);
                    if (toUnPress) {
                        this.setPressed(false);
                    }
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mDraggingThumbs != null) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    private int getValue(MotionEvent event, Thumb thumb) {
        return this.getValue(event, event.getActionIndex(), thumb);
    }

    private void setHotspot(float x, float y, Thumb thumb) {
        if (thumb == null || thumb.getThumb() == null) {
            return;
        }
        Drawable background = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21 && background != null) {
            background.setHotspot(x, y);
            Rect rect = thumb.getThumb().getBounds();
            int offsetY = this.getPaddingTop();
            background.setHotspotBounds(rect.left, rect.top + offsetY, rect.right, rect.bottom + offsetY);
        }
    }

    int getThumbOptOffset(Thumb thumb) {
        if (!this.mDrawThumbsApart) {
            return 0;
        }
        if (thumb == null || thumb.getThumb() == null) {
            return 0;
        }
        int thumbIdx = this.mThumbs.indexOf(thumb);
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            return thumbIdx == this.mThumbs.size() - 1 ? 0 : this.getThumbOptOffset(this.mThumbs.get(thumbIdx + 1)) + thumb.getThumb().getIntrinsicWidth();
        }
        return thumbIdx == 0 ? 0 : this.getThumbOptOffset(this.mThumbs.get(thumbIdx - 1)) + thumb.getThumb().getIntrinsicWidth();
    }

    private int getValue(MotionEvent event, int pointerIndex, Thumb thumb) {
        float scale;
        int width = this.getWidth();
        int available = this.getAvailable();
        int optThumbOffset = this.getThumbOptOffset(thumb);
        int x = (int)event.getX(pointerIndex);
        float progress = this.mScaleMin;
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            if (x > width - this.getPaddingRight()) {
                scale = 0.0f;
            } else if (x < this.getPaddingLeft()) {
                scale = 1.0f;
            } else {
                scale = (float)(available - x + this.getPaddingLeft() + optThumbOffset) / (float)available;
                progress = this.mScaleMin;
            }
        } else if (x < this.getPaddingLeft()) {
            scale = 0.0f;
        } else if (x > width - this.getPaddingRight()) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.getPaddingLeft() - optThumbOffset) / (float)available;
            progress = this.mScaleMin;
        }
        return Math.round(progress += scale * (float)this.getScaleSize());
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            this.setPressed(true);
            if (thumb.getThumb() != null) {
                this.invalidate(thumb.getThumb().getBounds());
            }
            this.mDraggingThumbs.add(thumb);
            this.drawableStateChanged();
            if (this.hasOnTrackingChangeListener()) {
                this.mOnTrackingChangeListener.onStartTrackingTouch(this, thumb, thumb.getValue());
            }
            this.attemptClaimDrag();
        }
    }

    void onStopTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            this.mDraggingThumbs.remove(thumb);
            if (this.hasOnTrackingChangeListener()) {
                this.mOnTrackingChangeListener.onStopTrackingTouch(this, thumb, thumb.getValue());
            }
            this.drawableStateChanged();
        }
    }

    void onStopTrackingTouch() {
        this.mDraggingThumbs.clear();
    }

    private boolean hasOnThumbValueChangeListener() {
        return this.mOnThumbValueChangeListener != null;
    }

    private boolean hasOnTrackingChangeListener() {
        return this.mOnTrackingChangeListener != null;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider == null) {
            this.mAccessibilityNodeProvider = new VirtualTreeProvider();
        }
        return this.mAccessibilityNodeProvider;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)MultiSlider.class.getName());
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            super.onRtlPropertiesChanged(layoutDirection);
            this.invalidate();
        }
    }

    public boolean isLayoutRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.getLayoutDirection() == 1;
        }
        return false;
    }

    public void invalidateDrawable(Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.getScrollX() + this.getPaddingLeft();
                int scrollY = this.getScrollY() + this.getPaddingTop();
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateTrackBounds(w, h);
        for (Thumb thumb : this.mThumbs) {
            this.updateThumb(thumb, w, h);
        }
    }

    private Drawable getTintedDrawable(Drawable drawable2, int tintColor) {
        if (drawable2 != null && tintColor != 0) {
            Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable2.mutate());
            DrawableCompat.setTint((Drawable)wrappedDrawable, (int)tintColor);
            return wrappedDrawable;
        }
        return drawable2;
    }

    class VirtualTreeProvider
    extends AccessibilityNodeProvider {
        static final int ACT_SET_PROGRESS = 16908349;
        final AccessibilityNodeInfo.AccessibilityAction ACTION_SET_PROGRESS = Build.VERSION.SDK_INT >= 21 ? new AccessibilityNodeInfo.AccessibilityAction(16908349, null) : null;

        public AccessibilityNodeInfo createAccessibilityNodeInfo(int thumbId) {
            AccessibilityNodeInfo info = null;
            if (thumbId == -1) {
                info = AccessibilityNodeInfo.obtain((View)MultiSlider.this);
                MultiSlider.this.onInitializeAccessibilityNodeInfo(info);
                int childCount = MultiSlider.this.mThumbs.size();
                for (int i = 0; i < childCount; ++i) {
                    info.addChild((View)MultiSlider.this, i);
                }
                if (MultiSlider.this.mThumbs.size() == 1) {
                    info.setScrollable(true);
                    if (Build.VERSION.SDK_INT >= 21) {
                        info.addAction(this.ACTION_SET_PROGRESS);
                        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    } else {
                        info.addAction(8192);
                        info.addAction(4096);
                    }
                }
            } else {
                Thumb thumb = (Thumb)MultiSlider.this.mThumbs.get(thumbId);
                if (thumb == null) {
                    return null;
                }
                info = AccessibilityNodeInfo.obtain((View)MultiSlider.this, (int)thumbId);
                info.setClassName((CharSequence)thumb.getClass().getName());
                info.setParent((View)MultiSlider.this);
                info.setSource((View)MultiSlider.this, thumbId);
                info.setContentDescription((CharSequence)("Multi-Slider thumb no:" + thumbId));
                if (Build.VERSION.SDK_INT >= 21) {
                    info.addAction(this.ACTION_SET_PROGRESS);
                    if (thumb.getPossibleMax() > thumb.value) {
                        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    }
                } else {
                    if (thumb.getPossibleMin() > thumb.value) {
                        info.addAction(8192);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        info.addAction(4096);
                    }
                }
                if (thumb.getThumb() != null) {
                    int[] loc = new int[2];
                    MultiSlider.this.getLocationOnScreen(loc);
                    Rect rect = thumb.getThumb().copyBounds();
                    rect.top += loc[1];
                    rect.left += loc[0];
                    rect.right += loc[0];
                    rect.bottom += loc[1];
                    info.setBoundsInScreen(rect);
                }
                info.setText((CharSequence)(thumb.tag + ": " + thumb.value));
                info.setEnabled(thumb.isEnabled());
                if (Build.VERSION.SDK_INT >= 24) {
                    info.setImportantForAccessibility(true);
                }
                info.setVisibleToUser(true);
                info.setScrollable(true);
            }
            return info;
        }

        public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String searched, int virtualViewId) {
            if (TextUtils.isEmpty((CharSequence)searched)) {
                return Collections.emptyList();
            }
            String searchedLowerCase = searched.toLowerCase();
            ArrayList<AccessibilityNodeInfo> result = null;
            if (virtualViewId == -1) {
                int childCount = MultiSlider.this.mThumbs.size();
                for (int i = 0; i < childCount; ++i) {
                    Thumb child = (Thumb)MultiSlider.this.mThumbs.get(i);
                    String textToLowerCase = child.tag.toLowerCase();
                    if (!textToLowerCase.contains(searchedLowerCase)) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(this.createAccessibilityNodeInfo(i));
                }
            } else {
                String textToLowerCase;
                Thumb virtualView = (Thumb)MultiSlider.this.mThumbs.get(virtualViewId);
                if (virtualView != null && (textToLowerCase = virtualView.tag.toLowerCase()).contains(searchedLowerCase)) {
                    result = new ArrayList<AccessibilityNodeInfo>();
                    result.add(this.createAccessibilityNodeInfo(virtualViewId));
                }
            }
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }

        public AccessibilityNodeInfo findFocus(int focus) {
            return super.findFocus(focus);
        }

        public boolean performAction(int virtualViewId, int action, Bundle arguments) {
            if (virtualViewId == -1) {
                return false;
            }
            if (virtualViewId >= MultiSlider.this.mThumbs.size()) {
                return false;
            }
            Thumb thumb = (Thumb)MultiSlider.this.mThumbs.get(virtualViewId);
            if (thumb == null) {
                return false;
            }
            switch (action) {
                case 4096: {
                    thumb.setValue(thumb.value + MultiSlider.this.getStep());
                    return true;
                }
                case 8192: {
                    thumb.setValue(thumb.value - MultiSlider.this.getStep());
                    return true;
                }
                case 16908349: {
                    thumb.setValue(arguments.getInt("value"));
                    return true;
                }
            }
            return false;
        }
    }

    public static class SimpleChangeListener
    implements OnThumbValueChangeListener,
    OnTrackingChangeListener {
        @Override
        public void onValueChanged(MultiSlider multiSlider, Thumb thumb, int thumbIndex, int value) {
        }

        @Override
        public void onStartTrackingTouch(MultiSlider multiSlider, Thumb thumb, int value) {
        }

        @Override
        public void onStopTrackingTouch(MultiSlider multiSlider, Thumb thumb, int value) {
        }
    }

    public class Thumb {
        int min;
        int max;
        int value;
        String tag = "thumb";
        Drawable thumb;
        Drawable range;
        int thumbOffset;
        private boolean isInvisible = false;
        private boolean isEnabled = true;

        public Thumb() {
            this.min = MultiSlider.this.mScaleMin;
            this.value = this.max = MultiSlider.this.mScaleMax;
        }

        public Drawable getRange() {
            return this.range;
        }

        public final Thumb setRange(Drawable range) {
            this.range = range;
            return this;
        }

        public boolean isEnabled() {
            return !this.isInvisibleThumb() && this.isEnabled;
        }

        public Thumb setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            if (this.getThumb() != null) {
                if (this.isEnabled()) {
                    this.getThumb().setState(new int[]{16842910});
                } else {
                    this.getThumb().setState(new int[]{-16842910});
                }
            }
            return this;
        }

        public boolean isInvisibleThumb() {
            return this.isInvisible;
        }

        public void setInvisibleThumb(boolean invisibleThumb) {
            this.isInvisible = invisibleThumb;
        }

        public int getPossibleMin() {
            int res = this.min;
            return res += MultiSlider.this.mThumbs.indexOf(this) * MultiSlider.this.mStepsThumbsApart;
        }

        public int getPossibleMax() {
            int res = this.max;
            return res -= (MultiSlider.this.mThumbs.size() - 1 - MultiSlider.this.mThumbs.indexOf(this)) * MultiSlider.this.mStepsThumbsApart;
        }

        public int getMin() {
            return this.min;
        }

        public Thumb setMin(int min) {
            if (min > this.max) {
                min = this.max;
            }
            if (min < MultiSlider.this.mScaleMin) {
                min = MultiSlider.this.mScaleMin;
            }
            if (this.min != min) {
                this.min = min;
                if (this.value < this.min) {
                    this.value = this.min;
                    MultiSlider.this.invalidate();
                }
            }
            return this;
        }

        public int getMax() {
            return this.max;
        }

        public Thumb setMax(int max) {
            if (max < this.min) {
                max = this.min;
            }
            if (max > MultiSlider.this.mScaleMax) {
                max = MultiSlider.this.mScaleMax;
            }
            if (this.max != max) {
                this.max = max;
                if (this.value > this.max) {
                    this.value = this.max;
                    MultiSlider.this.invalidate();
                }
            }
            return this;
        }

        public int getValue() {
            return this.value;
        }

        public Thumb setValue(int value) {
            if (MultiSlider.this.mThumbs.contains(this)) {
                MultiSlider.this.setThumbValue(this, value, false);
            } else {
                this.value = value;
            }
            return this;
        }

        public String getTag() {
            return this.tag;
        }

        public Thumb setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Drawable getThumb() {
            return this.thumb;
        }

        public Thumb setThumb(Drawable mThumb) {
            this.thumb = mThumb;
            return this;
        }

        public int getThumbOffset() {
            return this.thumbOffset;
        }

        public Thumb setThumbOffset(int mThumbOffset) {
            this.thumbOffset = mThumbOffset;
            return this;
        }
    }

    public static interface OnTrackingChangeListener {
        public void onStartTrackingTouch(MultiSlider var1, Thumb var2, int var3);

        public void onStopTrackingTouch(MultiSlider var1, Thumb var2, int var3);
    }

    public static interface OnThumbValueChangeListener {
        public void onValueChanged(MultiSlider var1, Thumb var2, int var3, int var4);
    }
}

