/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class AppiumServerAvailabilityChecker {
    private static final Duration CONNECT_TIMEOUT = Duration.ofMillis(500L);
    private static final Duration READ_TIMEOUT = Duration.ofSeconds(1L);
    private static final Duration MAX_POLL_INTERVAL = Duration.ofMillis(320L);
    private static final Duration MIN_POLL_INTERVAL = Duration.ofMillis(10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilAvailable(URL serverStatusUrl, Duration timeout) throws InterruptedException {
        Duration interval = MIN_POLL_INTERVAL;
        Instant start = Instant.now();
        IOException lastError = null;
        while (Duration.between(start, Instant.now()).compareTo(timeout) <= 0) {
            HttpURLConnection connection = null;
            try {
                connection = this.connectToUrl(serverStatusUrl);
                boolean bl = this.checkResponse(connection);
                return bl;
            }
            catch (IOException e) {
                lastError = e;
            }
            finally {
                Optional.ofNullable(connection).ifPresent(HttpURLConnection::disconnect);
            }
            Thread.sleep(interval.toMillis());
            interval = interval.compareTo(MAX_POLL_INTERVAL) >= 0 ? interval : interval.multipliedBy(2L);
        }
        throw new ConnectionTimeout(timeout, lastError);
    }

    private HttpURLConnection connectToUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout((int)CONNECT_TIMEOUT.toMillis());
        connection.setReadTimeout((int)READ_TIMEOUT.toMillis());
        connection.connect();
        return connection;
    }

    private boolean checkResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return true;
        }
        InputStream is = responseCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        throw new ConnectionError(connection.getURL(), responseCode, is);
    }

    public static class ConnectionTimeout
    extends RuntimeException {
        private final Duration timeout;

        public ConnectionTimeout(Duration timeout, Throwable cause) {
            super(ConnectionTimeout.class.getSimpleName(), cause);
            this.timeout = timeout;
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }
    }

    public static class ConnectionError
    extends RuntimeException {
        private static final int MAX_PAYLOAD_LEN = 1024;
        private final URL statusUrl;
        private final int responseCode;
        private final Optional<String> payload;

        public ConnectionError(URL statusUrl, int responseCode, InputStream body) {
            super(ConnectionError.class.getSimpleName());
            this.statusUrl = statusUrl;
            this.responseCode = responseCode;
            this.payload = ConnectionError.readResponseStreamSafely(body);
        }

        private static Optional<String> readResponseStreamSafely(InputStream is) {
            Optional<String> optional;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String currentLine;
                LinkedList<String> result = new LinkedList<String>();
                long payloadSize = 0L;
                while ((currentLine = br.readLine()) != null) {
                    result.addFirst(currentLine);
                    payloadSize += (long)currentLine.length();
                    while (payloadSize > 1024L && result.size() > 1) {
                        payloadSize -= (long)result.removeLast().length();
                    }
                }
                String s = ConnectionError.abbreviate(result);
                optional = s.isEmpty() ? Optional.empty() : Optional.of(s);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
            br.close();
            return optional;
        }

        private static String abbreviate(List<String> filo) {
            String result = String.join((CharSequence)"\n", filo).trim();
            return result.length() > 1024 ? "\u2026" + result.substring(0, 1024) : result;
        }

        @Generated
        public URL getStatusUrl() {
            return this.statusUrl;
        }

        @Generated
        public int getResponseCode() {
            return this.responseCode;
        }

        @Generated
        public Optional<String> getPayload() {
            return this.payload;
        }
    }
}

