/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.clipboard;

import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.clipboard.ClipboardContentType;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.UnsupportedCommandException;

public interface HasClipboard
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public void setClipboard(ClipboardContentType contentType, byte[] base64Content) {
        String extName = "mobile: setClipboard";
        Map<String, String> args = Map.of("content", new String(Objects.requireNonNull(base64Content), StandardCharsets.UTF_8), "contentType", contentType.name().toLowerCase());
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: setClipboard"), "mobile: setClipboard", args);
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute((ExecutesMethod)this, Map.entry(MobileCommand.SET_CLIPBOARD, args));
        }
    }

    default public String getClipboard(ClipboardContentType contentType) {
        String extName = "mobile: getClipboard";
        Map<String, String> args = Map.of("contentType", contentType.name().toLowerCase());
        try {
            return (String)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: getClipboard"), "mobile: getClipboard", args);
        }
        catch (UnsupportedCommandException e) {
            return (String)CommandExecutionHelper.execute((ExecutesMethod)this, Map.entry(MobileCommand.GET_CLIPBOARD, args));
        }
    }

    default public void setClipboardText(String text) {
        this.setClipboard(ClipboardContentType.PLAINTEXT, Base64.getMimeEncoder().encode(text.getBytes(StandardCharsets.UTF_8)));
    }

    default public String getClipboardText() {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.PLAINTEXT));
        return new String(base64decodedBytes, StandardCharsets.UTF_8);
    }
}

