/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.touch.offset;

import com.google.common.base.Preconditions;
import io.appium.java_client.touch.offset.PointOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class ElementOption
extends PointOption<ElementOption> {
    private String elementId;

    public static ElementOption element(WebElement element, Point offset) {
        return new ElementOption().withElement(element).withCoordinates(offset);
    }

    public static ElementOption element(WebElement element, int x, int y) {
        return new ElementOption().withElement(element).withCoordinates(x, y);
    }

    public static ElementOption element(WebElement element) {
        return new ElementOption().withElement(element);
    }

    @Override
    public ElementOption withCoordinates(Point offset) {
        super.withCoordinates(offset);
        return this;
    }

    @Override
    public ElementOption withCoordinates(int xOffset, int yOffset) {
        super.withCoordinates(xOffset, yOffset);
        return this;
    }

    public ElementOption withElement(WebElement element) {
        Objects.requireNonNull(element);
        Preconditions.checkArgument((boolean)true, (String)"Element should be an instance of the class which extends org.openqa.selenium.remote.RemoteWebElement", (Object)(element instanceof RemoteWebElement));
        this.elementId = ((RemoteWebElement)element).getId();
        return this;
    }

    @Override
    protected void verify() {
        Optional.ofNullable(this.elementId).orElseThrow(() -> new IllegalArgumentException("Element should be defined"));
    }

    @Override
    public Map<String, Object> build() {
        this.verify();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("element", this.elementId);
        Optional.ofNullable(this.coordinates).ifPresent(point -> {
            result.put("x", point.x);
            result.put("y", point.y);
        });
        return result;
    }
}

