/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.utils;

import io.appium.java_client.HasBrowserCheck;
import io.appium.java_client.pagefactory.bys.ContentType;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;

public final class WebDriverUnpackUtility {
    private static final String NATIVE_APP_PATTERN = "NATIVE_APP";

    private WebDriverUnpackUtility() {
    }

    public static <T> Optional<T> unpackObjectFromSearchContext(@Nullable SearchContext searchContext, Class<T> cls) {
        if (searchContext == null) {
            return Optional.empty();
        }
        if (cls.isAssignableFrom(searchContext.getClass())) {
            return Optional.of(cls.cast(searchContext));
        }
        if (searchContext instanceof WrapsDriver) {
            return WebDriverUnpackUtility.unpackObjectFromSearchContext((SearchContext)((WrapsDriver)searchContext).getWrappedDriver(), cls);
        }
        if (searchContext instanceof WrapsElement) {
            return WebDriverUnpackUtility.unpackObjectFromSearchContext((SearchContext)((WrapsElement)searchContext).getWrappedElement(), cls);
        }
        return Optional.empty();
    }

    @Nullable
    public static WebDriver unpackWebDriverFromSearchContext(@Nullable SearchContext searchContext) {
        return WebDriverUnpackUtility.unpackObjectFromSearchContext(searchContext, WebDriver.class).orElse(null);
    }

    public static ContentType getCurrentContentType(SearchContext context) {
        Optional<HasBrowserCheck> browserCheckHolder = WebDriverUnpackUtility.unpackObjectFromSearchContext(context, HasBrowserCheck.class);
        if (browserCheckHolder.filter(hbc -> !hbc.isBrowser()).isPresent()) {
            return ContentType.NATIVE_MOBILE_SPECIFIC;
        }
        Optional<ContextAware> contextAware = WebDriverUnpackUtility.unpackObjectFromSearchContext(context, ContextAware.class);
        if (contextAware.map(ContextAware::getContext).filter(c -> c.toUpperCase().contains(NATIVE_APP_PATTERN)).isPresent()) {
            return ContentType.NATIVE_MOBILE_SPECIFIC;
        }
        return ContentType.HTML_OR_DEFAULT;
    }
}

