/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import io.appium.java_client.proxy.MethodCallListener;
import io.appium.java_client.proxy.NotImplementedException;
import io.appium.java_client.proxy.ProxyListenersContainer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Interceptor.class);

    private Interceptor() {
    }

    @RuntimeType
    public static Object intercept(@This Object self, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) throws Throwable {
        Collection<MethodCallListener> listeners = ProxyListenersContainer.getInstance().getListeners(self);
        if (listeners.isEmpty()) {
            return callable.call();
        }
        listeners.forEach(listener -> {
            try {
                listener.beforeCall(self, method, args);
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                LOGGER.atError().addArgument(() -> self.getClass().getName()).addArgument(method::getName).log("Got an unexpected error in beforeCall listener of {}.{} method", (Object)e);
            }
        });
        UUID noResult = UUID.randomUUID();
        Object result = noResult;
        for (MethodCallListener listener2 : listeners) {
            try {
                result = listener2.call(self, method, args, callable);
                break;
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                try {
                    return listener2.onError(self, method, args, e);
                }
                catch (NotImplementedException notImplementedException) {
                    throw e;
                }
            }
        }
        if (noResult.equals(result)) {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                for (MethodCallListener listener3 : listeners) {
                    try {
                        return listener3.onError(self, method, args, e);
                    }
                    catch (NotImplementedException notImplementedException) {
                    }
                }
                throw e;
            }
        }
        UUID endResult = result == noResult ? null : result;
        listeners.forEach(listener -> {
            try {
                listener.afterCall(self, method, args, endResult);
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                LOGGER.atError().addArgument(() -> self.getClass().getName()).addArgument(method::getName).log("Got an unexpected error in afterCall listener of {}.{} method", (Object)e);
            }
        });
        return endResult;
    }
}

