/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.internal.CapabilityHelpers;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriverException;

public interface HasBrowserCheck
extends ExecutesMethod,
HasCapabilities {
    default public boolean isBrowser() {
        String browserName = CapabilityHelpers.getCapability(this.getCapabilities(), "browserName", String.class);
        if (!StringUtils.isBlank((CharSequence)browserName)) {
            try {
                return (Boolean)Preconditions.checkNotNull(CommandExecutionHelper.executeScript(this, "return !!window.navigator;"));
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        if (!(this instanceof ContextAware)) {
            return false;
        }
        try {
            return !StringUtils.containsIgnoreCase((CharSequence)((ContextAware)this).getContext(), (CharSequence)"NATIVE_APP");
        }
        catch (WebDriverException e) {
            return false;
        }
    }
}

