/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.InvalidServerInstanceException;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public final class AppiumServiceBuilder
extends DriverService.Builder<AppiumDriverLocalService, AppiumServiceBuilder> {
    public static final String APPIUM_PATH = "APPIUM_BINARY_PATH";
    private static final String NODE_PATH = "NODE_BINARY_PATH";
    public static final String BROADCAST_IP_ADDRESS = "0.0.0.0";
    private static final Path APPIUM_PATH_SUFFIX = Paths.get("appium", "build", "lib", "main.js");
    public static final int DEFAULT_APPIUM_PORT = 4723;
    private final Map<String, String> serverArguments = new HashMap<String, String>();
    private File appiumJS;
    private File node;
    private String ipAddress = "0.0.0.0";
    private Capabilities capabilities;
    private boolean autoQuoteCapabilitiesOnWindows = false;
    private static final Function<File, String> APPIUM_JS_NOT_EXIST_ERROR = fullPath -> String.format("The main Appium script does not exist at '%s'", fullPath.getAbsolutePath());
    private static final Function<File, String> NODE_JS_NOT_EXIST_ERROR = fullPath -> String.format("The main NodeJS executable does not exist at '%s'", fullPath.getAbsolutePath());
    private static final List<String> PATH_CAPABILITIES = ImmutableList.of((Object)"keystorePath", (Object)"chromedriverExecutable", (Object)"app");

    public AppiumServiceBuilder() {
        this.usingPort(4723);
        this.withEnvironment((Map)System.getenv());
    }

    public int score(Capabilities capabilities) {
        String browserName;
        int score = 0;
        if (capabilities.getCapability("platformName") != null) {
            ++score;
        }
        if (Browser.CHROME.is(browserName = capabilities.getBrowserName()) || browserName.equalsIgnoreCase("Android") || Browser.SAFARI.is(browserName)) {
            ++score;
        }
        return score;
    }

    private static File validatePath(@Nullable String fullPath, String errMsg) {
        if (fullPath == null) {
            throw new InvalidServerInstanceException(errMsg);
        }
        File result = new File(fullPath);
        if (!result.exists()) {
            throw new InvalidServerInstanceException(errMsg);
        }
        return result;
    }

    private static File findBinary(String name, String errMsg) {
        return AppiumServiceBuilder.validatePath(new ExecutableFinder().find(name), errMsg);
    }

    private static File findNpm() {
        return AppiumServiceBuilder.findBinary("npm", "Node Package Manager (npm) is either not installed or its executable is not present in PATH");
    }

    private static File findMainScript() {
        String nodeModulesRoot;
        File npm = AppiumServiceBuilder.findNpm();
        List<String> cmdLine = SystemUtils.IS_OS_WINDOWS ? Arrays.asList("cmd.exe", "/c", String.format("\"%s\" root -g", npm.getAbsolutePath())) : Arrays.asList(npm.getAbsolutePath(), "root", "-g");
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        try {
            nodeModulesRoot = IOUtils.toString((InputStream)pb.start().getInputStream(), (Charset)StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new InvalidServerInstanceException("Cannot retrieve the path to the folder where NodeJS modules are located", e);
        }
        File mainAppiumJs = Paths.get(nodeModulesRoot, APPIUM_PATH_SUFFIX.toString()).toFile();
        if (!mainAppiumJs.exists()) {
            throw new InvalidServerInstanceException(APPIUM_JS_NOT_EXIST_ERROR.apply(mainAppiumJs));
        }
        return mainAppiumJs;
    }

    protected File findDefaultExecutable() {
        if (this.node != null) {
            AppiumServiceBuilder.validatePath(this.node.getAbsolutePath(), NODE_JS_NOT_EXIST_ERROR.apply(this.node));
            return this.node;
        }
        File node = AppiumServiceBuilder.loadPathFromEnv(NODE_PATH);
        if (node != null) {
            AppiumServiceBuilder.validatePath(node.getAbsolutePath(), NODE_JS_NOT_EXIST_ERROR.apply(node));
            this.node = node;
            return this.node;
        }
        this.node = AppiumServiceBuilder.findBinary("node", "NodeJS is either not installed or its executable not present in PATH");
        return this.node;
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument) {
        this.serverArguments.put(argument.getArgument(), "");
        return this;
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument, String value) {
        String argName;
        switch (argName = argument.getArgument().trim().toLowerCase()) {
            case "--port": 
            case "-p": {
                this.usingPort(Integer.parseInt(value));
                break;
            }
            case "--address": 
            case "-a": {
                this.withIPAddress(value);
                break;
            }
            case "--log": 
            case "-g": {
                this.withLogFile(new File(value));
                break;
            }
            default: {
                this.serverArguments.put(argName, value);
            }
        }
        return this;
    }

    public AppiumServiceBuilder withCapabilities(Capabilities capabilities) {
        this.capabilities = (this.capabilities == null ? capabilities : this.capabilities).merge(capabilities);
        return this;
    }

    public AppiumServiceBuilder withCapabilities(Capabilities capabilities, boolean autoQuoteCapabilitiesOnWindows) {
        this.autoQuoteCapabilitiesOnWindows = autoQuoteCapabilitiesOnWindows;
        return this.withCapabilities(capabilities);
    }

    public AppiumServiceBuilder withAppiumJS(File appiumJS) {
        this.appiumJS = appiumJS;
        return this;
    }

    public AppiumServiceBuilder withIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    private static File loadPathFromEnv(String envVarName) {
        String fullPath = System.getProperty(envVarName);
        if (StringUtils.isBlank((CharSequence)fullPath)) {
            fullPath = System.getenv(envVarName);
        }
        return StringUtils.isBlank((CharSequence)fullPath) ? null : new File(fullPath);
    }

    private void loadPathToMainScript() {
        if (this.appiumJS != null) {
            AppiumServiceBuilder.validatePath(this.appiumJS.getAbsolutePath(), APPIUM_JS_NOT_EXIST_ERROR.apply(this.appiumJS));
            return;
        }
        File mainScript = AppiumServiceBuilder.loadPathFromEnv(APPIUM_PATH);
        if (mainScript != null) {
            AppiumServiceBuilder.validatePath(mainScript.getAbsolutePath(), APPIUM_JS_NOT_EXIST_ERROR.apply(mainScript));
            this.appiumJS = mainScript;
            return;
        }
        this.appiumJS = AppiumServiceBuilder.findMainScript();
    }

    private String capabilitiesToQuotedCmdlineArg() {
        if (this.capabilities == null) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        Map capabilitiesMap = this.capabilities.asMap();
        Set entries = capabilitiesMap.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof String) {
                String valueString = (String)value;
                value = PATH_CAPABILITIES.contains(entry.getKey()) ? "\\\"" + valueString.replace("\\", "/") + "\\\"" : "\\\"" + valueString + "\\\"";
            } else {
                value = String.valueOf(value);
            }
            String key = "\\\"" + (String)entry.getKey() + "\\\"";
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key).append(": ").append(value);
        }
        return "{" + result + "}";
    }

    private String capabilitiesToCmdlineArg() {
        if (this.autoQuoteCapabilitiesOnWindows && Platform.getCurrent().is(Platform.WINDOWS)) {
            return this.capabilitiesToQuotedCmdlineArg();
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        return gson.toJson((Object)this.capabilities.asMap());
    }

    protected ImmutableList<String> createArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        this.loadPathToMainScript();
        argList.add(this.appiumJS.getAbsolutePath());
        argList.add("--port");
        argList.add(String.valueOf(this.getPort()));
        if (StringUtils.isBlank((CharSequence)this.ipAddress)) {
            this.ipAddress = BROADCAST_IP_ADDRESS;
        } else {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!(validator.isValid(this.ipAddress) || validator.isValidInet4Address(this.ipAddress) || validator.isValidInet6Address(this.ipAddress))) {
                throw new IllegalArgumentException("The invalid IP address " + this.ipAddress + " is defined");
            }
        }
        argList.add("--address");
        argList.add(this.ipAddress);
        File log = this.getLogFile();
        if (log != null) {
            argList.add("--log");
            argList.add(log.getAbsolutePath());
        }
        Set<Map.Entry<String, String>> entries = this.serverArguments.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String argument = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)argument) || value == null) continue;
            argList.add(argument);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            argList.add(value);
        }
        if (this.capabilities != null) {
            argList.add("--default-capabilities");
            argList.add(this.capabilitiesToCmdlineArg());
        }
        return new ImmutableList.Builder().addAll(argList).build();
    }

    public AppiumServiceBuilder usingDriverExecutable(File nodeJSExecutable) {
        return (AppiumServiceBuilder)super.usingDriverExecutable(nodeJSExecutable);
    }

    public AppiumServiceBuilder usingPort(int port) {
        return (AppiumServiceBuilder)super.usingPort(port);
    }

    public AppiumServiceBuilder usingAnyFreePort() {
        return (AppiumServiceBuilder)super.usingAnyFreePort();
    }

    public AppiumServiceBuilder withEnvironment(Map<String, String> environment) {
        return (AppiumServiceBuilder)super.withEnvironment(environment);
    }

    public AppiumServiceBuilder withLogFile(File logFile) {
        return (AppiumServiceBuilder)super.withLogFile(logFile);
    }

    protected AppiumDriverLocalService createDriverService(File nodeJSExecutable, int nodeJSPort, Duration startupTimeout, List<String> nodeArguments, Map<String, String> nodeEnvironment) {
        try {
            return new AppiumDriverLocalService(this.ipAddress, nodeJSExecutable, nodeJSPort, startupTimeout, nodeArguments, nodeEnvironment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

