/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.bys.ContentMappedBy;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements CacheableLocator {
    private static final String exceptionMessageIfElementNotFound = "Can't locate an element by this strategy: %s";
    private final boolean shouldCache;
    private final By by;
    private final Duration duration;
    private final SearchContext searchContext;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    public AppiumElementLocator(SearchContext searchContext, By by, boolean shouldCache, Duration duration) {
        this.searchContext = searchContext;
        this.shouldCache = shouldCache;
        this.duration = duration;
        this.by = by;
    }

    private static By getBy(By currentBy, SearchContext currentContent) {
        if (!ContentMappedBy.class.isAssignableFrom(currentBy.getClass())) {
            return currentBy;
        }
        return ((ContentMappedBy)((Object)ContentMappedBy.class.cast(currentBy))).useContent(WebDriverUnpackUtility.getCurrentContentType(currentContent));
    }

    private <T> T waitFor(Supplier<T> supplier) {
        WaitingFunction function = new WaitingFunction();
        try {
            FluentWait wait = new FluentWait(supplier).ignoring(NoSuchElementException.class);
            wait.withTimeout(this.duration);
            return (T)wait.until(function);
        }
        catch (TimeoutException e) {
            if (function.foundStaleElementReferenceException != null) {
                throw (StaleElementReferenceException)StaleElementReferenceException.class.cast(function.foundStaleElementReferenceException);
            }
            throw e;
        }
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        By bySearching = AppiumElementLocator.getBy(this.by, this.searchContext);
        try {
            WebElement result = this.waitFor(() -> this.searchContext.findElement(bySearching));
            if (this.shouldCache) {
                this.cachedElement = result;
            }
            return result;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            throw new NoSuchElementException(String.format(exceptionMessageIfElementNotFound, bySearching.toString()), e);
        }
    }

    public List<WebElement> findElements() {
        ArrayList<WebElement> result;
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        try {
            result = this.waitFor(() -> {
                List list = this.searchContext.findElements(AppiumElementLocator.getBy(this.by, this.searchContext));
                return list.size() > 0 ? list : null;
            });
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            result = new ArrayList<WebElement>();
        }
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    @Override
    public boolean isLookUpCached() {
        return this.shouldCache;
    }

    public String toString() {
        return String.format("Located by %s", this.by);
    }

    private static class WaitingFunction<T>
    implements Function<Supplier<T>, T> {
        private Throwable foundStaleElementReferenceException;

        private WaitingFunction() {
        }

        @Override
        public T apply(Supplier<T> supplier) {
            this.foundStaleElementReferenceException = null;
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                boolean isRootCauseStaleElementReferenceException = false;
                boolean isRootCauseInvalidSelector = ThrowableUtil.isInvalidSelectorRootCause(e);
                if (!isRootCauseInvalidSelector) {
                    isRootCauseStaleElementReferenceException = ThrowableUtil.isStaleElementReferenceException(e);
                }
                if (isRootCauseStaleElementReferenceException) {
                    this.foundStaleElementReferenceException = ThrowableUtil.extractReadableException(e);
                }
                if (!isRootCauseInvalidSelector & !isRootCauseStaleElementReferenceException) {
                    Throwable shouldBeThrown = ThrowableUtil.extractReadableException(e);
                    if (shouldBeThrown != null) {
                        if (NoSuchElementException.class.equals(shouldBeThrown.getClass())) {
                            throw (NoSuchElementException)NoSuchElementException.class.cast(shouldBeThrown);
                        }
                        throw new WebDriverException(shouldBeThrown);
                    }
                    throw new WebDriverException(e);
                }
                return null;
            }
        }
    }
}

