/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.OverrideWidget;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.WidgetConstructorUtil;
import io.appium.java_client.pagefactory.bys.ContentType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

class OverrideWidgetReader {
    private static final Class<? extends Widget> EMPTY = Widget.class;
    private static final String HTML = "html";
    private static final String ANDROID_UI_AUTOMATOR = "androidUIAutomator";
    private static final String IOS_UI_AUTOMATION = "iOSUIAutomation";
    private static final String SELENDROID = "selendroid";
    private static final String IOS_XCUIT_AUTOMATION = "iOSXCUITAutomation";
    private static final String WINDOWS_AUTOMATION = "windowsAutomation";

    OverrideWidgetReader() {
    }

    private static Class<? extends Widget> getConvenientClass(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement, String method) {
        Class convenientClass;
        OverrideWidget overrideWidget = annotatedElement.getAnnotation(OverrideWidget.class);
        try {
            if (overrideWidget == null || (convenientClass = (Class)OverrideWidget.class.getDeclaredMethod(method, new Class[0]).invoke((Object)overrideWidget, new Object[0])).equals(EMPTY)) {
                convenientClass = declaredClass;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (!declaredClass.isAssignableFrom(convenientClass)) {
            throw new IllegalArgumentException(new InstantiationException(String.valueOf(declaredClass.getName()) + " is not assignable from " + convenientClass.getName()));
        }
        return convenientClass;
    }

    static Class<? extends Widget> getDefaultOrHTMLWidgetClass(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement) {
        return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, HTML);
    }

    static Class<? extends Widget> getMobileNativeWidgetClass(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement, String platform, String automation) {
        String transformedPlatform = String.valueOf(platform).toUpperCase().trim();
        String transformedAutomation = String.valueOf(automation).toUpperCase().trim();
        if ("Android".equalsIgnoreCase(transformedPlatform)) {
            if ("Selendroid".equalsIgnoreCase(transformedAutomation)) {
                return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, SELENDROID);
            }
            return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, ANDROID_UI_AUTOMATOR);
        }
        if ("iOS".equalsIgnoreCase(transformedPlatform)) {
            if ("XCuiTest".equalsIgnoreCase(transformedAutomation)) {
                return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, IOS_XCUIT_AUTOMATION);
            }
            return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, IOS_UI_AUTOMATION);
        }
        if ("Windows".equalsIgnoreCase(transformedPlatform)) {
            return OverrideWidgetReader.getConvenientClass(declaredClass, annotatedElement, WINDOWS_AUTOMATION);
        }
        return OverrideWidgetReader.getDefaultOrHTMLWidgetClass(declaredClass, annotatedElement);
    }

    private static Constructor<? extends Widget> getConstructorOfADefaultOrHTMLWidget(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement) {
        Class<? extends Widget> clazz = OverrideWidgetReader.getDefaultOrHTMLWidgetClass(declaredClass, annotatedElement);
        return WidgetConstructorUtil.findConvenientConstructor(clazz);
    }

    private static Constructor<? extends Widget> getConstructorOfAMobileNativeWidgets(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement, String platform, String automation) {
        Class<? extends Widget> clazz = OverrideWidgetReader.getMobileNativeWidgetClass(declaredClass, annotatedElement, platform, automation);
        return WidgetConstructorUtil.findConvenientConstructor(clazz);
    }

    protected static Map<ContentType, Constructor<? extends Widget>> read(Class<? extends Widget> declaredClass, AnnotatedElement annotatedElement, String platform, String automation) {
        HashMap<ContentType, Constructor<? extends Widget>> result = new HashMap<ContentType, Constructor<? extends Widget>>();
        result.put(ContentType.HTML_OR_DEFAULT, OverrideWidgetReader.getConstructorOfADefaultOrHTMLWidget(declaredClass, annotatedElement));
        result.put(ContentType.NATIVE_MOBILE_SPECIFIC, OverrideWidgetReader.getConstructorOfAMobileNativeWidgets(declaredClass, annotatedElement, platform, automation));
        return result;
    }
}

