/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import io.appium.java_client.remote.NewAppiumSessionPayload;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final Optional<DriverService> serviceOptional;

    private AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        super(additionalCommands, Optional.ofNullable(service).map(DriverService::getUrl).orElse(addressOfRemoteServer), httpClientFactory);
        this.serviceOptional = Optional.ofNullable(service);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, (DriverService)Preconditions.checkNotNull((Object)service), null, httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, (URL)Preconditions.checkNotNull((Object)addressOfRemoteServer), httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, HttpClient.Factory.createDefault());
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, HttpClient.Factory.createDefault());
    }

    private <B> B getPrivateFieldValue(String fieldName, Class<B> fieldType) {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return fieldType.cast(f.get((Object)this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void setPrivateFieldValue(String fieldName, Object newValue) {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set((Object)this, newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Map<String, CommandInfo> getAdditionalCommands() {
        return this.getPrivateFieldValue("additionalCommands", Map.class);
    }

    private CommandCodec<HttpRequest> getCommandCodec() {
        return this.getPrivateFieldValue("commandCodec", CommandCodec.class);
    }

    private void setCommandCodec(CommandCodec<HttpRequest> newCodec) {
        this.setPrivateFieldValue("commandCodec", newCodec);
    }

    private void setResponseCodec(ResponseCodec<HttpResponse> codec) {
        this.setPrivateFieldValue("responseCodec", codec);
    }

    private HttpClient getClient() {
        return this.getPrivateFieldValue("client", HttpClient.class);
    }

    private Response createSession(Command command) throws IOException {
        if (this.getCommandCodec() != null) {
            throw new SessionNotCreatedException("Session already exists");
        }
        ProtocolHandshake handshake = new ProtocolHandshake(){

            /*
             * Loose catch block
             */
            public ProtocolHandshake.Result createSession(HttpClient client, Command command) throws IOException {
                Capabilities desiredCapabilities = (Capabilities)command.getParameters().get("desiredCapabilities");
                Capabilities desired = desiredCapabilities == null ? new ImmutableCapabilities() : desiredCapabilities;
                int threshold = (int)Math.min(Runtime.getRuntime().freeMemory() / 10L, Integer.MAX_VALUE);
                FileBackedOutputStream os = new FileBackedOutputStream(threshold);
                try {
                    ProtocolHandshake.Result result;
                    BufferedInputStream contentStream;
                    InputStream rawIn;
                    Throwable throwable;
                    block24: {
                        block23: {
                            CountingOutputStream counter = new CountingOutputStream((OutputStream)os);
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counter, StandardCharsets.UTF_8);
                            NewAppiumSessionPayload payload = NewAppiumSessionPayload.create(desired);
                            payload.writeTo(writer);
                            throwable = null;
                            Object var11_13 = null;
                            rawIn = os.asByteSource().openBufferedStream();
                            contentStream = new BufferedInputStream(rawIn);
                            Method createSessionMethod = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("createSession", HttpClient.class, InputStream.class, Long.TYPE);
                            createSessionMethod.setAccessible(true);
                            Optional result2 = (Optional)createSessionMethod.invoke((Object)this, client, contentStream, counter.getCount());
                            result = result2.map(result1 -> {
                                ProtocolHandshake.Result toReturn = (ProtocolHandshake.Result)result2.get();
                                Logger.getLogger(ProtocolHandshake.class.getName()).info(String.format("Detected dialect: %s", toReturn.getDialect()));
                                return toReturn;
                            }).orElseThrow(() -> new SessionNotCreatedException(String.format("Unable to create new remote session. desired capabilities = %s", desired)));
                            if (contentStream == null) break block23;
                            contentStream.close();
                        }
                        if (rawIn == null) break block24;
                        rawIn.close();
                    }
                    os.reset();
                    return result;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (contentStream != null) {
                                    contentStream.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (rawIn != null) {
                                        rawIn.close();
                                    }
                                    throw throwable;
                                }
                                catch (Throwable throwable4) {
                                    try {
                                        if (throwable == null) {
                                            throwable = throwable4;
                                        } else if (throwable != throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                        throw throwable;
                                    }
                                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                        throw new WebDriverException(String.format("It is impossible to create a new session because 'createSession' which takes %s, %s and %s was not found or it is not accessible", HttpClient.class.getSimpleName(), InputStream.class.getSimpleName(), Long.TYPE.getSimpleName()), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    os.reset();
                    throw throwable;
                }
            }
        };
        ProtocolHandshake.Result result = handshake.createSession(this.getClient(), command);
        Dialect dialect = result.getDialect();
        this.setCommandCodec((CommandCodec<HttpRequest>)dialect.getCommandCodec());
        this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((AppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
        this.setResponseCodec((ResponseCodec<HttpResponse>)dialect.getResponseCodec());
        return result.createResponse();
    }

    public Response execute(Command command) throws WebDriverException {
        Response response;
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), (Throwable)e);
                }
            });
        }
        try {
            try {
                response = "newSession".equals(command.getName()) ? this.createSession(command) : super.execute(command);
            }
            catch (Throwable t) {
                Throwable rootCause = Throwables.getRootCause((Throwable)t);
                if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                    throw this.serviceOptional.map(service -> {
                        if (service.isRunning()) {
                            return new WebDriverException("The session is closed!", rootCause);
                        }
                        return new WebDriverException("The appium server has accidentally died!", rootCause);
                    }).orElseGet((Supplier<WebDriverException>)((com.google.common.base.Supplier)() -> new WebDriverException(rootCause.getMessage(), rootCause)));
                }
                Throwables.throwIfUnchecked((Throwable)t);
                throw new WebDriverException(t);
            }
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
        if ("newSession".equals(command.getName()) && this.getCommandCodec() instanceof W3CHttpCommandCodec) {
            this.setCommandCodec((CommandCodec<HttpRequest>)new AppiumW3CHttpCommandCodec());
            this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((AppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
        }
        return response;
    }
}

