/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.events;

import io.appium.java_client.events.DefaultAspect;
import io.appium.java_client.events.api.Listener;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
class DefaultBeanConfiguration {
    public static final String LISTENABLE_OBJECT = "object";
    public static final String COMPONENT_BEAN = "component";
    protected final List<Listener> listeners = new ArrayList<Listener>();
    protected WebDriver driver;
    protected AbstractApplicationContext context;

    DefaultBeanConfiguration() {
    }

    @Scope(value="prototype")
    @Bean(name={"object"})
    public <T> T init(T t, WebDriver driver, List<Listener> listeners, AbstractApplicationContext context) {
        this.driver = driver;
        this.listeners.addAll(listeners);
        this.context = context;
        return t;
    }

    @Scope(value="prototype")
    @Bean(name={"component"})
    public <T> T getComponent(T t) {
        return t;
    }

    @Scope(value="prototype")
    @Bean(name={"defaultAspect"})
    public DefaultAspect getAspect() {
        DefaultAspect aspect = new DefaultAspect(this.context, this.driver);
        aspect.add(this.listeners);
        return aspect;
    }
}

