/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class ScreenRecordingUploadOptions {
    private String remotePath;
    private String user;
    private String pass;
    private String method;

    public static ScreenRecordingUploadOptions uploadOptions() {
        return new ScreenRecordingUploadOptions();
    }

    public ScreenRecordingUploadOptions withRemotePath(String remotePath) {
        this.remotePath = (String)Preconditions.checkNotNull((Object)remotePath);
        return this;
    }

    public ScreenRecordingUploadOptions withAuthCredentials(String user, String pass) {
        this.user = (String)Preconditions.checkNotNull((Object)user);
        this.pass = (String)Preconditions.checkNotNull((Object)pass);
        return this;
    }

    public ScreenRecordingUploadOptions withHttpMethod(RequestMethod method) {
        this.method = ((RequestMethod)((Object)Preconditions.checkNotNull((Object)((Object)method)))).name();
        return this;
    }

    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this.remotePath).map(x -> builder.put((Object)"remotePath", x));
        Optional.ofNullable(this.user).map(x -> builder.put((Object)"user", x));
        Optional.ofNullable(this.pass).map(x -> builder.put((Object)"pass", x));
        Optional.ofNullable(this.method).map(x -> builder.put((Object)"method", x));
        return builder.build();
    }

    public static enum RequestMethod {
        POST,
        PUT;

    }
}

