/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.android.Connection;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.internal.HasIdentity;

public class AndroidMobileCommandHelper
extends MobileCommand {
    public static Map.Entry<String, Map<String, ?>> currentActivityCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(CURRENT_ACTIVITY, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> currentPackageCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_CURRENT_PACKAGE, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> endTestCoverageCommand(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(END_TEST_COVERAGE, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> getSupportedPerformanceDataTypesCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_SUPPORTED_PERFORMANCE_DATA_TYPES, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getPerformanceDataCommand(String packageName, String dataType, int dataReadTimeout) throws Exception {
        String[] parameters = new String[]{"packageName", "dataType", "dataReadTimeout"};
        Object[] values = new Object[]{packageName, dataType, dataReadTimeout};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(GET_PERFORMANCE_DATA, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> getDisplayDensityCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_DISPLAY_DENSITY, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getNetworkConnectionCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_NETWORK_CONNECTION, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> getSystemBarsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(GET_SYSTEM_BARS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> isKeyboardShownCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(IS_KEYBOARD_SHOWN, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> isLockedCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(IS_LOCKED, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> openNotificationsCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(OPEN_NOTIFICATIONS, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> pushFileCommandCommand(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, base64Data};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(PUSH_FILE, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> setConnectionCommand(Connection connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.bitMask)};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(SET_NETWORK_CONNECTION, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }

    public static Map.Entry<String, Map<String, ?>> startActivityCommand(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String optionalIntentArguments, boolean stopApp) throws IllegalArgumentException {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appPackage) && !StringUtils.isBlank((CharSequence)appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        String targetWaitPackage = !StringUtils.isBlank((CharSequence)appWaitPackage) ? appWaitPackage : "";
        String targetWaitActivity = !StringUtils.isBlank((CharSequence)appWaitActivity) ? appWaitActivity : "";
        String targetIntentAction = !StringUtils.isBlank((CharSequence)intentAction) ? intentAction : "";
        String targetIntentCategory = !StringUtils.isBlank((CharSequence)intentCategory) ? intentCategory : "";
        String targetIntentFlags = !StringUtils.isBlank((CharSequence)intentFlags) ? intentFlags : "";
        String targetOptionalIntentArguments = !StringUtils.isBlank((CharSequence)optionalIntentArguments) ? optionalIntentArguments : "";
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"appPackage", (Object)appPackage).put((Object)"appActivity", (Object)appActivity).put((Object)"appWaitPackage", (Object)targetWaitPackage).put((Object)"appWaitActivity", (Object)targetWaitActivity).put((Object)"dontStopAppOnReset", (Object)(!stopApp ? 1 : 0)).put((Object)"intentAction", (Object)targetIntentAction).put((Object)"intentCategory", (Object)targetIntentCategory).put((Object)"intentFlags", (Object)targetIntentFlags).put((Object)"optionalIntentArguments", (Object)targetOptionalIntentArguments).build();
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(START_ACTIVITY, parameters);
    }

    public static Map.Entry<String, Map<String, ?>> toggleLocationServicesCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(TOGGLE_LOCATION_SERVICES, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> unlockCommand() {
        return new AbstractMap.SimpleEntry<String, ImmutableMap>(UNLOCK, ImmutableMap.of());
    }

    public static Map.Entry<String, Map<String, ?>> replaceElementValueCommand(HasIdentity hasIdentityObject, String value) {
        String[] parameters = new String[]{"id", "value"};
        Object[] values = new Object[]{hasIdentityObject.getId(), value};
        return new AbstractMap.SimpleEntry<String, ImmutableMap<String, Object>>(REPLACE_VALUE, AndroidMobileCommandHelper.prepareArguments(parameters, values));
    }
}

