/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.appium.java_client.pagefactory.OverrideWidgetReader;
import io.appium.java_client.pagefactory.Widget;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.By;

class WidgetByBuilder
extends DefaultElementByBuilder {
    protected WidgetByBuilder(String platform, String automation) {
        super(platform, automation);
    }

    private static Class<?> getClassFromAListField(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(listType.getClass())) {
            listType = ((ParameterizedType)listType).getRawType();
        }
        return (Class)listType;
    }

    private By getByFromDeclaredClass(WhatIsNeeded whatIsNeeded) {
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        Field field = (Field)Field.class.cast(annotatedElement);
        By result = null;
        try {
            Class<?> declaredClass = List.class.isAssignableFrom(field.getType()) ? WidgetByBuilder.getClassFromAListField(field) : field.getType();
            Class<? extends Widget> convenientClass = whatIsNeeded.equals((Object)WhatIsNeeded.DEFAULT_OR_HTML) ? OverrideWidgetReader.getDefaultOrHTMLWidgetClass(declaredClass, field) : OverrideWidgetReader.getMobileNativeWidgetClass(declaredClass, field, this.platform, this.automation);
            while (result == null && !convenientClass.equals(Object.class)) {
                this.setAnnotated(convenientClass);
                result = whatIsNeeded.equals((Object)WhatIsNeeded.DEFAULT_OR_HTML) ? super.buildDefaultBy() : super.buildMobileNativeBy();
                convenientClass = convenientClass.getSuperclass();
            }
            By by = result;
            return by;
        }
        finally {
            if (field != null) {
                this.setAnnotated(field);
            }
        }
    }

    @Override
    protected By buildDefaultBy() {
        By defaultBy = super.buildDefaultBy();
        if (defaultBy != null) {
            return defaultBy;
        }
        return this.getByFromDeclaredClass(WhatIsNeeded.DEFAULT_OR_HTML);
    }

    @Override
    protected By buildMobileNativeBy() {
        By mobileBy = super.buildMobileNativeBy();
        if (mobileBy != null) {
            return mobileBy;
        }
        return this.getByFromDeclaredClass(WhatIsNeeded.MOBILE_NATIVE);
    }

    private static enum WhatIsNeeded {
        DEFAULT_OR_HTML,
        MOBILE_NATIVE;

    }
}

