/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.ScrollsTo;
import io.appium.java_client.ios.GetsNamedTextField;
import io.appium.java_client.ios.IOSDeviceActionShortcuts;
import io.appium.java_client.ios.internal.JsonToIOSElementConverter;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.http.HttpClient;

public class IOSDriver<T extends WebElement>
extends AppiumDriver<T>
implements IOSDeviceActionShortcuts,
GetsNamedTextField<T>,
FindsByIosUIAutomation<T> {
    private static final String IOS_PLATFORM = "iOS";

    public IOSDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, capabilities, JsonToIOSElementConverter.class);
    }

    public IOSDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(Capabilities desiredCapabilities) {
        super(IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    @Override
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        this.doSwipe(startx, starty, endx - startx, endy - starty, duration);
    }

    @Override
    @Deprecated
    public T scrollTo(String text) {
        return (T)((WebElement)((ScrollsTo)this.findElementByClassName("UIATableView")).scrollTo(text));
    }

    @Override
    @Deprecated
    public T scrollToExact(String text) {
        return (T)((WebElement)((ScrollsTo)this.findElementByClassName("UIATableView")).scrollToExact(text));
    }

    @Override
    public void hideKeyboard(String strategy, String keyName) {
        String[] parameters = new String[]{"strategy", "key"};
        Object[] values = new Object[]{strategy, keyName};
        this.execute("hideKeyboard", (Map)IOSDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void hideKeyboard(String keyName) {
        this.execute("hideKeyboard", (Map)ImmutableMap.of((Object)"keyName", (Object)keyName));
    }

    @Override
    public void shake() {
        this.execute("shake");
    }

    @Override
    @Deprecated
    public T getNamedTextField(String name) {
        WebElement element = this.findElementByAccessibilityId(name);
        if (element.getTagName() != "TextField") {
            return (T)((WebElement)((FindsByAccessibilityId)element).findElementByAccessibilityId(name));
        }
        return (T)element;
    }

    @Override
    public T findElementByIosUIAutomation(String using) throws WebDriverException {
        return (T)this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<T> findElementsByIosUIAutomation(String using) throws WebDriverException {
        return this.findElements("-ios uiautomation", using);
    }

    public void lockDevice(int seconds) {
        this.execute("lock", (Map)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }
}

