/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByIosUIAutomation;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class MobileBy
extends By {
    private final String locatorString;

    protected MobileBy(String locatorString) {
        if (StringUtils.isBlank((CharSequence)locatorString)) {
            throw new IllegalArgumentException("Must supply a not empty locator value.");
        }
        this.locatorString = locatorString;
    }

    protected String getLocatorString() {
        return this.locatorString;
    }

    public static By IosUIAutomation(String iOSAutomationText) {
        return new ByIosUIAutomation(iOSAutomationText);
    }

    public static By AndroidUIAutomator(String uiautomatorText) {
        return new ByAndroidUIAutomator(uiautomatorText);
    }

    public static By AccessibilityId(String accessibilityId) {
        return new ByAccessibilityId(accessibilityId);
    }

    public static class ByAccessibilityId
    extends MobileBy
    implements Serializable {
        public ByAccessibilityId(String accessibilityId) {
            super(accessibilityId);
        }

        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByAccessibilityId)context).findElementsByAccessibilityId(this.getLocatorString());
        }

        public WebElement findElement(SearchContext context) {
            return ((FindsByAccessibilityId)context).findElementByAccessibilityId(this.getLocatorString());
        }

        public String toString() {
            return "By.AccessibilityId: " + this.getLocatorString();
        }
    }

    public static class ByAndroidUIAutomator
    extends MobileBy
    implements Serializable {
        public ByAndroidUIAutomator(String uiautomatorText) {
            super(uiautomatorText);
        }

        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByAndroidUIAutomator)context).findElementsByAndroidUIAutomator(this.getLocatorString());
        }

        public WebElement findElement(SearchContext context) {
            return ((FindsByAndroidUIAutomator)context).findElementByAndroidUIAutomator(this.getLocatorString());
        }

        public String toString() {
            return "By.AndroidUIAutomator: " + this.getLocatorString();
        }
    }

    public static class ByIosUIAutomation
    extends MobileBy
    implements Serializable {
        public ByIosUIAutomation(String iOSAutomationText) {
            super(iOSAutomationText);
        }

        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByIosUIAutomation)context).findElementsByIosUIAutomation(this.getLocatorString());
        }

        public WebElement findElement(SearchContext context) {
            return ((FindsByIosUIAutomation)context).findElementByIosUIAutomation(this.getLocatorString());
        }

        public String toString() {
            return "By.IosUIAutomation: " + this.getLocatorString();
        }
    }
}

