/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.ListOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.service.DriverService;

public final class AppiumDriverLocalService
extends DriverService {
    private static final String URL_MASK = "http://%s:%d/wd/hub";
    private final File nodeJSExec;
    private final int nodeJSPort;
    private final ImmutableList<String> nodeJSArgs;
    private final ImmutableMap<String, String> nodeJSEnvironment;
    private final String ipAddress;
    private final long startupTimeout;
    private final TimeUnit timeUnit;
    private final ReentrantLock lock = new ReentrantLock();
    private final ListOutputStream stream = new ListOutputStream().add(System.out);
    private CommandLine process = null;

    AppiumDriverLocalService(String ipAddress, File nodeJSExec, int nodeJSPort, ImmutableList<String> nodeJSArgs, ImmutableMap<String, String> nodeJSEnvironment, long startupTimeout, TimeUnit timeUnit) throws IOException {
        super(nodeJSExec, nodeJSPort, nodeJSArgs, nodeJSEnvironment);
        this.ipAddress = ipAddress;
        this.nodeJSExec = nodeJSExec;
        this.nodeJSPort = nodeJSPort;
        this.nodeJSArgs = nodeJSArgs;
        this.nodeJSEnvironment = nodeJSEnvironment;
        this.startupTimeout = startupTimeout;
        this.timeUnit = timeUnit;
    }

    public URL getUrl() {
        try {
            return new URL(String.format(URL_MASK, this.ipAddress, this.nodeJSPort));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        this.lock.lock();
        if (this.process == null) {
            return false;
        }
        if (!this.process.isRunning()) {
            return false;
        }
        try {
            this.ping(500L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (UrlChecker.TimeoutException timeoutException) {
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ping(long time, TimeUnit timeUnit) throws UrlChecker.TimeoutException {
        URL url = this.getUrl();
        try {
            URL status = new URL(String.valueOf(url.toString()) + "/status");
            new UrlChecker().waitUntilAvailable(time, timeUnit, new URL[]{status});
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("There is something wrong with the URL " + url.toString().toString() + "/status");
        }
    }

    public void start() throws AppiumServerHasNotBeenStartedLocallyException {
        this.lock.lock();
        if (this.isRunning()) {
            return;
        }
        try {
            try {
                this.process = new CommandLine(this.nodeJSExec.getCanonicalPath(), (String[])this.nodeJSArgs.toArray((Object[])new String[0]));
                this.process.setEnvironmentVariables(this.nodeJSEnvironment);
                this.process.copyOutputTo((OutputStream)this.stream);
                this.process.executeAsync();
                this.ping(this.startupTimeout, this.timeUnit);
            }
            catch (Throwable e) {
                String processStream;
                this.destroyProcess();
                String msgTxt = "The local appium server has not been started. The given Node.js executable: " + this.nodeJSExec.getAbsolutePath() + " Arguments: " + this.nodeJSArgs.toString() + " " + "\n";
                if (this.process != null && !StringUtils.isBlank((CharSequence)(processStream = this.process.getStdOut()))) {
                    msgTxt = String.valueOf(msgTxt) + "Process output: " + processStream + "\n";
                }
                throw new AppiumServerHasNotBeenStartedLocallyException(msgTxt, e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        this.destroyProcess();
        this.lock.unlock();
    }

    private void destroyProcess() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public String getStdOut() {
        if (this.process != null) {
            return this.process.getStdOut();
        }
        return null;
    }

    public void addOutPutStream(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream parameter is NULL!");
        this.stream.add(outputStream);
    }

    public void addOutPutStreams(List<OutputStream> outputStreams) {
        Preconditions.checkNotNull(outputStreams, (Object)"outputStreams parameter is NULL!");
        for (OutputStream stream : outputStreams) {
            this.addOutPutStream(stream);
        }
    }

    public static AppiumDriverLocalService buildDefaultService() {
        return AppiumDriverLocalService.buildService(new AppiumServiceBuilder());
    }

    public static AppiumDriverLocalService buildService(AppiumServiceBuilder builder) {
        return (AppiumDriverLocalService)builder.build();
    }
}

