/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.MobileElement;
import io.appium.java_client.NetworkConnectionSetting;
import io.appium.java_client.android.AndroidDeviceActionShortcuts;
import io.appium.java_client.android.HasNetworkConnection;
import io.appium.java_client.android.PushesFiles;
import io.appium.java_client.android.StartsActivity;
import io.appium.java_client.android.internal.JsonToAndroidElementConverter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;

public class AndroidDriver
extends AppiumDriver
implements AndroidDeviceActionShortcuts,
HasNetworkConnection,
PushesFiles,
StartsActivity,
FindsByAndroidUIAutomator {
    private static final String ANDROID_PLATFORM = "Android";
    private final String METASTATE_PARAM = "metastate";
    private final String CONNECTION_NAME_PARAM = "name";
    private final String CONNECTION_PARAM_PARAM = "parameters";
    private final String DATA_PARAM = "data";
    private final String INTENT_PARAM = "intent";
    private final String CONNECTION_NAME_VALUE = "network_connection";

    public AndroidDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
        this.setElementConverter(new JsonToAndroidElementConverter(this));
    }

    @Override
    public MobileElement scrollTo(String text) {
        String uiScrollables = AndroidDriver.UiScrollable("new UiSelector().descriptionContains(\"" + text + "\")") + AndroidDriver.UiScrollable("new UiSelector().textContains(\"" + text + "\")");
        return (MobileElement)this.findElementByAndroidUIAutomator(uiScrollables);
    }

    @Override
    public MobileElement scrollToExact(String text) {
        String uiScrollables = AndroidDriver.UiScrollable("new UiSelector().description(\"" + text + "\")") + AndroidDriver.UiScrollable("new UiSelector().text(\"" + text + "\")");
        return (MobileElement)this.findElementByAndroidUIAutomator(uiScrollables);
    }

    static String UiScrollable(String uiSelector) {
        return "new UiScrollable(new UiSelector().scrollable(true).instance(0)).scrollIntoView(" + uiSelector + ".instance(0));";
    }

    @Override
    public void sendKeyEvent(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        this.execute("keyEvent", (Map<String, ?>)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public NetworkConnectionSetting getNetworkConnection() {
        Response response = this.execute("getNetworkConnection");
        return new NetworkConnectionSetting(Integer.parseInt(response.getValue().toString()));
    }

    @Override
    public void setNetworkConnection(NetworkConnectionSetting connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.value)};
        this.execute("setNetworkConnection", (Map<String, ?>)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void pushFile(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, base64Data};
        this.execute("pushFile", (Map<String, ?>)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity) throws IllegalArgumentException {
        Preconditions.checkArgument((AndroidDriver._isNotNullOrEmpty(appPackage) && AndroidDriver._isNotNullOrEmpty(appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        appWaitPackage = AndroidDriver._isNotNullOrEmpty(appWaitPackage) ? appWaitPackage : "";
        appWaitActivity = AndroidDriver._isNotNullOrEmpty(appWaitActivity) ? appWaitActivity : "";
        ImmutableMap parameters = ImmutableMap.of((Object)"appPackage", (Object)appPackage, (Object)"appActivity", (Object)appActivity, (Object)"appWaitPackage", (Object)appWaitPackage, (Object)"appWaitActivity", (Object)appWaitActivity);
        this.execute("startActivity", (Map<String, ?>)parameters);
    }

    @Override
    public void startActivity(String appPackage, String appActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, null, null);
    }

    public void endTestCoverage(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        this.execute("endTestCoverage", (Map<String, ?>)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    public String currentActivity() {
        Response response = this.execute("currentActivity");
        return response.getValue().toString();
    }

    public void openNotifications() {
        this.execute("openNotifications");
    }

    public boolean isLocked() {
        Response response = this.execute("isLocked");
        return Boolean.parseBoolean(response.getValue().toString());
    }

    public void toggleLocationServices() {
        this.execute("toggleLocationServices");
    }

    public void ignoreUnimportantViews(Boolean compress) {
        this.setSetting(AppiumSetting.IGNORE_UNIMPORTANT_VIEWS, compress);
    }

    @Override
    public WebElement findElementByAndroidUIAutomator(String using) {
        return this.findElement("-android uiautomator", using);
    }

    @Override
    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        return this.findElements("-android uiautomator", using);
    }
}

