/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MissingParameterException;
import io.appium.java_client.MobileDriver;
import io.appium.java_client.TouchAction;

public class MultiTouchAction {
    private MobileDriver driver;
    ImmutableList.Builder actions;

    public MultiTouchAction(MobileDriver driver) {
        this.driver = driver;
        this.actions = ImmutableList.builder();
    }

    public MultiTouchAction add(TouchAction action) {
        this.actions.add((Object)action);
        return this;
    }

    public void perform() {
        int size = this.actions.build().size();
        if (size > 1) {
            this.driver.performMultiTouchAction(this);
        } else if (size == 1) {
            this.driver.performTouchAction((TouchAction)this.actions.build().get(0));
        } else {
            throw new MissingParameterException("MultiTouch action must have at least one TouchAction added before it can be performed");
        }
    }

    protected ImmutableMap getParameters() {
        ImmutableList.Builder listOfActionChains = ImmutableList.builder();
        ImmutableList touchActions = this.actions.build();
        for (TouchAction action : touchActions) {
            listOfActionChains.add(action.getParameters().get((Object)"actions"));
        }
        return ImmutableMap.of((Object)"actions", (Object)listOfActionChains.build());
    }
}

