/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.DeviceActionShortcuts;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.HasAppStrings;
import io.appium.java_client.InteractsWithApps;
import io.appium.java_client.InteractsWithFiles;
import io.appium.java_client.MobileDriver;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.ScrollsTo;
import io.appium.java_client.TouchAction;
import io.appium.java_client.TouchShortcuts;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.HttpMethod;

public abstract class AppiumDriver
extends RemoteWebDriver
implements MobileDriver,
ContextAware,
Rotatable,
FindsByAccessibilityId,
LocationContext,
DeviceActionShortcuts,
TouchShortcuts,
InteractsWithFiles,
InteractsWithApps,
ScrollsTo,
HasAppStrings {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private URL remoteAddress;
    private RemoteLocationContext locationContext;
    private ExecuteMethod executeMethod = new AppiumExecutionMethod(this);
    protected final String KEY_CODE = "keycode";
    protected final String PATH = "path";
    private final String SETTINGS = "settings";
    private final String LANGUAGE_PARAM = "language";

    protected static Capabilities substituteMobilePlatform(Capabilities originalCapabilities, String newPlatform) {
        DesiredCapabilities dc = new DesiredCapabilities(originalCapabilities);
        dc.setCapability("platformName", newPlatform);
        return dc;
    }

    protected static ImmutableMap<String, Object> getCommandImmutableMap(String param, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)param, value);
        return builder.build();
    }

    protected static ImmutableMap<String, Object> getCommandImmutableMap(String[] params, Object[] values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < params.length; ++i) {
            if (!AppiumDriver._isNotNullOrEmpty(params[i]) || !AppiumDriver._isNotNullOrEmpty(values[i])) continue;
            builder.put((Object)params[i], values[i]);
        }
        return builder.build();
    }

    public AppiumDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, desiredCapabilities);
        this.remoteAddress = remoteAddress;
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"reset", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/reset")).put((Object)"getStrings", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/strings")).put((Object)"keyEvent", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/keyevent")).put((Object)"currentActivity", (Object)AppiumDriver.getC("/session/:sessionId/appium/device/current_activity")).put((Object)"setValue", (Object)AppiumDriver.postC("/session/:sessionId/appium/element/:id/value")).put((Object)"pullFile", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/pull_file")).put((Object)"pullFolder", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/pull_folder")).put((Object)"hideKeyboard", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/hide_keyboard")).put((Object)"pushFile", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/push_file")).put((Object)"runAppInBackground", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/background")).put((Object)"performTouchAction", (Object)AppiumDriver.postC("/session/:sessionId/touch/perform")).put((Object)"performMultiTouch", (Object)AppiumDriver.postC("/session/:sessionId/touch/multi/perform")).put((Object)"isAppInstalled", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/app_installed")).put((Object)"installApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/install_app")).put((Object)"removeApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/remove_app")).put((Object)"launchApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/launch")).put((Object)"closeApp", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/close")).put((Object)"endTestCoverage", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/end_test_coverage")).put((Object)"lock", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/lock")).put((Object)"isLocked", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/is_locked")).put((Object)"shake", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/shake")).put((Object)"complexFind", (Object)AppiumDriver.postC("/session/:sessionId/appium/app/complex_find")).put((Object)"openNotifications", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/open_notifications")).put((Object)"getNetworkConnection", (Object)AppiumDriver.getC("/session/:sessionId/network_connection")).put((Object)"setNetworkConnection", (Object)AppiumDriver.postC("/session/:sessionId/network_connection")).put((Object)"getSettings", (Object)AppiumDriver.getC("/session/:sessionId/appium/settings")).put((Object)"setSettings", (Object)AppiumDriver.postC("/session/:sessionId/appium/settings")).put((Object)"startActivity", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/start_activity")).put((Object)"toggleLocationServices", (Object)AppiumDriver.postC("/session/:sessionId/appium/device/toggle_location_services"));
        ImmutableMap mobileCommands = builder.build();
        HttpCommandExecutor mobileExecutor = new HttpCommandExecutor((Map)mobileCommands, remoteAddress);
        super.setCommandExecutor((CommandExecutor)mobileExecutor);
        super.setErrorHandler(errorHandler);
    }

    @Override
    public Response execute(String driverCommand, Map<String, ?> parameters) {
        return super.execute(driverCommand, parameters);
    }

    protected Response execute(String command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public void resetApp() {
        this.execute("reset");
    }

    @Override
    public boolean isAppInstalled(String bundleId) {
        Response response = this.execute("isAppInstalled", (Map<String, ?>)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
        return Boolean.parseBoolean(response.getValue().toString());
    }

    @Override
    public void installApp(String appPath) {
        this.execute("installApp", (Map<String, ?>)ImmutableMap.of((Object)"appPath", (Object)appPath));
    }

    @Override
    public void removeApp(String bundleId) {
        this.execute("removeApp", (Map<String, ?>)ImmutableMap.of((Object)"bundleId", (Object)bundleId));
    }

    @Override
    public void launchApp() {
        this.execute("launchApp");
    }

    @Override
    public void closeApp() {
        this.execute("closeApp");
    }

    @Override
    public void runAppInBackground(int seconds) {
        this.execute("runAppInBackground", (Map<String, ?>)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }

    @Override
    public void sendKeyEvent(int key) {
        this.execute("keyEvent", (Map<String, ?>)AppiumDriver.getCommandImmutableMap("keycode", key));
    }

    @Override
    public void hideKeyboard() {
        this.execute("hideKeyboard");
    }

    @Override
    public byte[] pullFile(String remotePath) {
        Response response = this.execute("pullFile", (Map<String, ?>)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    @Override
    public byte[] pullFolder(String remotePath) {
        Response response = this.execute("pullFolder", (Map<String, ?>)ImmutableMap.of((Object)"path", (Object)remotePath));
        String base64String = response.getValue().toString();
        return DatatypeConverter.parseBase64Binary((String)base64String);
    }

    @Override
    public TouchAction performTouchAction(TouchAction touchAction) {
        ImmutableMap<String, ImmutableList> parameters = touchAction.getParameters();
        touchAction.clearParameters();
        this.execute("performTouchAction", (Map<String, ?>)parameters);
        return touchAction;
    }

    @Override
    public void performMultiTouchAction(MultiTouchAction multiAction) {
        ImmutableMap parameters = multiAction.getParameters();
        this.execute("performMultiTouch", (Map<String, ?>)parameters);
    }

    @Override
    public void tap(int fingers, WebElement element, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        for (int i = 0; i < fingers; ++i) {
            multiTouch.add(this.createTap(element, duration));
        }
        multiTouch.perform();
    }

    @Override
    public void tap(int fingers, int x, int y, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        for (int i = 0; i < fingers; ++i) {
            multiTouch.add(this.createTap(x, y, duration));
        }
        multiTouch.perform();
    }

    @Override
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        TouchAction touchAction = new TouchAction(this);
        touchAction.press(startx, starty).waitAction(duration).moveTo(endx, endy).release();
        touchAction.perform();
    }

    @Override
    public void pinch(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(el, center.getX(), center.getY() - yOffset).moveTo(el).release();
        TouchAction action1 = new TouchAction(this).press(el, center.getX(), center.getY() + yOffset).moveTo(el).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void pinch(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y - yOffset).moveTo(x, y).release();
        TouchAction action1 = new TouchAction(this).press(x, y + yOffset).moveTo(x, y).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void zoom(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(el).moveTo(el, center.getX(), center.getY() - yOffset).release();
        TouchAction action1 = new TouchAction(this).press(el).moveTo(el, center.getX(), center.getY() + yOffset).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    @Override
    public void zoom(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y).moveTo(x, y - yOffset).release();
        TouchAction action1 = new TouchAction(this).press(x, y).moveTo(x, y + yOffset).release();
        multiTouch.add(action0).add(action1);
        multiTouch.perform();
    }

    public JsonObject getSettings() {
        Response response = this.execute("getSettings");
        JsonParser parser = new JsonParser();
        JsonObject settings = (JsonObject)parser.parse(response.getValue().toString());
        return settings;
    }

    private void setSettings(ImmutableMap<?, ?> settings) {
        this.execute("setSettings", (Map<String, ?>)AppiumDriver.getCommandImmutableMap("settings", settings));
    }

    protected void setSetting(AppiumSetting setting, Object value) {
        this.setSettings(AppiumDriver.getCommandImmutableMap(setting.toString(), value));
    }

    public void lockScreen(int seconds) {
        this.execute("lock", (Map<String, ?>)ImmutableMap.of((Object)"seconds", (Object)seconds));
    }

    public WebDriver context(String name) {
        if (!AppiumDriver._isNotNullOrEmpty(name)) {
            throw new IllegalArgumentException("Must supply a context name");
        }
        this.execute("switchToContext", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        return this;
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        if (contextName.equals("null")) {
            return null;
        }
        return contextName;
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map<String, ?>)ImmutableMap.of((Object)"orientation", (Object)orientation.value().toUpperCase()));
    }

    public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = response.getValue().toString().toLowerCase();
        if (orientation.equals(ScreenOrientation.LANDSCAPE.value())) {
            return ScreenOrientation.LANDSCAPE;
        }
        if (orientation.equals(ScreenOrientation.PORTRAIT.value())) {
            return ScreenOrientation.PORTRAIT;
        }
        throw new WebDriverException("Unexpected orientation returned: " + orientation);
    }

    @Override
    public WebElement findElementByAccessibilityId(String using) {
        return this.findElement("accessibility id", using);
    }

    @Override
    public List<WebElement> findElementsByAccessibilityId(String using) {
        return this.findElements("accessibility id", using);
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    @Override
    public String getAppStrings() {
        Response response = this.execute("getStrings");
        return response.getValue().toString();
    }

    @Override
    public String getAppStrings(String language) {
        Response response = this.execute("getStrings", (Map<String, ?>)AppiumDriver.getCommandImmutableMap("language", language));
        return response.getValue().toString();
    }

    private TouchAction createTap(WebElement element, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(element).waitAction(duration).release();
    }

    private TouchAction createTap(int x, int y, int duration) {
        TouchAction tap = new TouchAction(this);
        return tap.press(x, y).waitAction(duration).release();
    }

    private static CommandInfo getC(String url) {
        return new CommandInfo(url, HttpMethod.GET);
    }

    private static CommandInfo postC(String url) {
        return new CommandInfo(url, HttpMethod.POST);
    }

    private static CommandInfo deleteC(String url) {
        return new CommandInfo(url, HttpMethod.DELETE);
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    protected static boolean _isNotNullOrEmpty(String str) {
        return str != null && !str.isEmpty() && str.trim().length() > 0;
    }

    protected static boolean _isNotNullOrEmpty(Object ob) {
        return ob != null;
    }
}

