/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger;

import io.apimatic.coreinterfaces.logger.configuration.HttpLoggingConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class LoggerUtilities {
    private static final List<String> NON_SENSITIVE_HEADERS = Arrays.asList("Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Access-Control-Allow-Origin", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Keep-Alive", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Range", "Referer", "Retry-After", "Server", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "X-Forwarded-For", "X-Requested-With", "X-Powered-By").stream().map(String::toLowerCase).collect(Collectors.toList());

    private LoggerUtilities() {
    }

    public static Map<String, String> getHeadersToLog(HttpLoggingConfiguration loggingConfiguration, Map<String, String> headers, boolean maskSensitiveHeaders) {
        Map<String, String> extractedHeaders = LoggerUtilities.extractHeadersToLog(headers, loggingConfiguration.getHeadersToInclude(), loggingConfiguration.getHeadersToExclude());
        return LoggerUtilities.filterSensitiveHeaders(extractedHeaders, loggingConfiguration.getHeadersToUnmask(), maskSensitiveHeaders);
    }

    public static Map<String, String> extractHeadersToLog(Map<String, String> headers, List<String> headersToInclude, List<String> headersToExclude) {
        if (!headersToInclude.isEmpty()) {
            return LoggerUtilities.extractIncludedHeaders(headers, headersToInclude);
        }
        if (!headersToExclude.isEmpty()) {
            return LoggerUtilities.extractExcludedHeaders(headers, headersToExclude);
        }
        return headers;
    }

    public static Map<String, String> filterSensitiveHeaders(Map<String, String> headers, List<String> headersToUnmask, boolean maskSensitiveHeaders) {
        if (!maskSensitiveHeaders) {
            return headers;
        }
        HashMap<String, String> filteredHeaders = new HashMap<String, String>();
        headers.forEach((key, value) -> {
            String headerKey = key.toLowerCase();
            boolean isNonSensitive = NON_SENSITIVE_HEADERS.contains(headerKey) || headersToUnmask.contains(headerKey);
            filteredHeaders.put((String)key, isNonSensitive ? value : "**Redacted**");
        });
        return filteredHeaders;
    }

    public static Map<String, String> extractIncludedHeaders(Map<String, String> headers, List<String> headersToInclude) {
        HashMap<String, String> extractedHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (!headersToInclude.contains(entry.getKey().toLowerCase())) continue;
            extractedHeaders.put(entry.getKey(), entry.getValue());
        }
        return extractedHeaders;
    }

    public static Map<String, String> extractExcludedHeaders(Map<String, String> headers, List<String> headersToExclude) {
        HashMap<String, String> extractedHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (headersToExclude.contains(entry.getKey().toLowerCase())) continue;
            extractedHeaders.put(entry.getKey(), entry.getValue());
        }
        return extractedHeaders;
    }
}

