/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.configurations.http.request;

import io.apimatic.coreinterfaces.http.request.ArraySerializationFormat;
import io.apimatic.coreinterfaces.http.request.configuration.CoreEndpointConfiguration;
import io.apimatic.coreinterfaces.http.request.configuration.RetryOption;

public class EndpointConfiguration
implements CoreEndpointConfiguration {
    private final boolean hasBinaryResponse;
    private final RetryOption retryOption;
    private final ArraySerializationFormat arraySerializationFormat;

    public EndpointConfiguration(boolean hasBinary, RetryOption retryOption, ArraySerializationFormat arraySerializationFormat) {
        this.hasBinaryResponse = hasBinary;
        this.retryOption = retryOption;
        this.arraySerializationFormat = arraySerializationFormat;
    }

    public RetryOption getRetryOption() {
        return this.retryOption;
    }

    public boolean hasBinaryResponse() {
        return this.hasBinaryResponse;
    }

    public ArraySerializationFormat getArraySerializationFormat() {
        return this.arraySerializationFormat;
    }

    public Builder toBuilder() {
        return new Builder().hasBinaryResponse(this.hasBinaryResponse).retryOption(this.retryOption).arraySerializationFormat(this.arraySerializationFormat);
    }

    public static class Builder {
        private boolean hasBinaryResponse;
        private RetryOption retryOption = RetryOption.DEFAULT;
        private ArraySerializationFormat arraySerializationFormat = ArraySerializationFormat.INDEXED;

        public Builder hasBinaryResponse(boolean hasBinary) {
            this.hasBinaryResponse = hasBinary;
            return this;
        }

        public Builder retryOption(RetryOption retryOption) {
            this.retryOption = retryOption;
            return this;
        }

        public Builder arraySerializationFormat(ArraySerializationFormat arraySerializationFormat) {
            this.arraySerializationFormat = arraySerializationFormat;
            return this;
        }

        public EndpointConfiguration build() {
            return new EndpointConfiguration(this.hasBinaryResponse, this.retryOption, this.arraySerializationFormat);
        }
    }
}

