/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.apimatic.core.utilities.CoreHelper;
import java.io.IOException;

public class CoreJsonObject {
    @JsonValue
    private JsonNode jsonNode;

    @JsonCreator
    protected CoreJsonObject(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public static CoreJsonObject fromJsonString(String jsonString) throws IOException {
        if (jsonString == null) {
            return new CoreJsonObject(null);
        }
        JsonNode node = CoreHelper.getMapper().readTree(jsonString);
        if (node.isObject()) {
            return new CoreJsonObject(node);
        }
        throw new IOException("Provided JSON string must contain a valid JSON object.");
    }

    public Object getStoredObject() {
        return CoreHelper.deserializeAsObject(this.toString());
    }

    public String toString() {
        try {
            return CoreHelper.getMapper().writeValueAsString((Object)this.jsonNode);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

