/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger.configurations;

import io.apimatic.core.logger.configurations.SdkBaseHttpLoggingConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SdkHttpLoggingConfiguration<T extends SdkHttpLoggingConfiguration<T, B>, B extends Builder<T, B>>
extends SdkBaseHttpLoggingConfiguration {
    protected SdkHttpLoggingConfiguration(Builder<T, B> builder) {
        this.setLogBody(((Builder)builder).logBody);
        this.setLogHeaders(((Builder)builder).logHeaders);
        this.excludeHeaders(((Builder)builder).excludeHeaders.toArray(new String[0]));
        this.includeHeaders(((Builder)builder).includeHeaders.toArray(new String[0]));
        this.unmaskHeaders(((Builder)builder).unmaskHeaders.toArray(new String[0]));
    }

    public static abstract class Builder<T extends SdkHttpLoggingConfiguration<T, B>, B extends Builder<T, B>> {
        private boolean logBody = false;
        private boolean logHeaders = false;
        private List<String> excludeHeaders = new ArrayList<String>();
        private List<String> includeHeaders = new ArrayList<String>();
        private List<String> unmaskHeaders = new ArrayList<String>();

        public B body(boolean logBody) {
            this.logBody = logBody;
            return this.self();
        }

        public B headers(boolean logHeaders) {
            this.logHeaders = logHeaders;
            return this.self();
        }

        public B excludeHeaders(String ... excludeHeaders) {
            this.excludeHeaders = Arrays.stream(excludeHeaders).map(String::toLowerCase).collect(Collectors.toList());
            return this.self();
        }

        public B includeHeaders(String ... includeHeaders) {
            this.includeHeaders = Arrays.stream(includeHeaders).map(String::toLowerCase).collect(Collectors.toList());
            return this.self();
        }

        public B unmaskHeaders(String ... unmaskHeaders) {
            this.unmaskHeaders = Arrays.stream(unmaskHeaders).map(String::toLowerCase).collect(Collectors.toList());
            return this.self();
        }

        protected abstract B self();

        public abstract T build();
    }
}

