/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.security.impl.AbstractSecurityContext;
import io.apiman.manager.api.security.impl.KeycloakAdminClient;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.LocaleUtils;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

@ApplicationScoped
@Alternative
public class KeycloakSecurityContext
extends AbstractSecurityContext {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(KeycloakSecurityContext.class);
    private volatile KeycloakAdminClient keycloakAdminClient;

    @Inject
    public KeycloakSecurityContext(IStorageQuery query, IStorage storage, ApiManagerConfig config) {
        super(query, storage, config);
    }

    @Override
    public String getCurrentUser() {
        return ((HttpServletRequest)servletRequest.get()).getRemoteUser();
    }

    @Override
    public String getFullName() {
        HttpServletRequest request = (HttpServletRequest)servletRequest.get();
        org.keycloak.KeycloakSecurityContext session = (org.keycloak.KeycloakSecurityContext)request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
        if (session != null) {
            return session.getToken().getName();
        }
        return null;
    }

    @Override
    public String getEmail() {
        HttpServletRequest request = (HttpServletRequest)servletRequest.get();
        org.keycloak.KeycloakSecurityContext session = (org.keycloak.KeycloakSecurityContext)request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
        if (session != null) {
            return session.getToken().getEmail();
        }
        return null;
    }

    @Override
    public Locale getLocale() {
        HttpServletRequest request = (HttpServletRequest)servletRequest.get();
        org.keycloak.KeycloakSecurityContext session = (org.keycloak.KeycloakSecurityContext)request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
        if (session != null) {
            return Optional.ofNullable(LocaleUtils.toLocale((String)session.getToken().getLocale())).orElse(request.getLocale());
        }
        return null;
    }

    @Override
    public List<UserDto> getRemoteUsersWithRole(String roleName) {
        List<UserDto> keycloakUsersWithRole = this.getKeycloakAdminClient().getUsersForRole(roleName);
        LOGGER.debug("Keycloak users for role {0} (using same realm as configured): {2}", new Object[]{roleName, keycloakUsersWithRole});
        return keycloakUsersWithRole;
    }

    @Override
    public List<UserDto> getUsersWithRole(String roleName, String orgName) {
        List<UserDto> apimanUsers = super.getUsersWithRole(roleName, orgName);
        LOGGER.debug("Apiman stored users for role {0} and org {1}: {2}", new Object[]{roleName, orgName, apimanUsers});
        return Stream.concat(apimanUsers.stream(), this.getRemoteUsersWithRole(roleName).stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeycloakAdminClient getKeycloakAdminClient() {
        if (this.keycloakAdminClient == null) {
            KeycloakSecurityContext keycloakSecurityContext = this;
            synchronized (keycloakSecurityContext) {
                HttpServletRequest request = (HttpServletRequest)servletRequest.get();
                RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
                this.keycloakAdminClient = new KeycloakAdminClient(session.getDeployment());
                return this.keycloakAdminClient;
            }
        }
        return this.keycloakAdminClient;
    }
}

