/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.idm.UserMapper;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.i18n.Messages;
import io.apiman.manager.api.security.impl.DiscoverabilityOptionsParser;
import io.apiman.manager.api.security.impl.IndexedDiscoverabilities;
import io.apiman.manager.api.security.impl.IndexedPermissions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractSecurityContext
implements ISecurityContext {
    protected static final ThreadLocal<HttpServletRequest> servletRequest = new ThreadLocal();
    private static final ThreadLocal<IndexedPermissions> permissions = new ThreadLocal();
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(AbstractSecurityContext.class);
    private static final ThreadLocal<IndexedDiscoverabilities> discoverabilities = ThreadLocal.withInitial(IndexedDiscoverabilities::new);
    private static final UserMapper userMapper = UserMapper.INSTANCE;
    private final IStorageQuery query;
    private final IStorage storage;
    private final DiscoverabilityOptionsParser discoverabilityConfig;

    public AbstractSecurityContext(IStorageQuery query, IStorage storage, ApiManagerConfig config) {
        this.query = query;
        this.storage = storage;
        this.discoverabilityConfig = new DiscoverabilityOptionsParser(config.getIdmDiscoverabilityMappings());
    }

    protected static void clearPermissions() {
        permissions.remove();
        discoverabilities.remove();
    }

    @Override
    public boolean isAdmin() {
        return servletRequest.get().isUserInRole("apiadmin");
    }

    @Override
    public String getRequestHeader(String headerName) {
        return servletRequest.get().getHeader(headerName);
    }

    @Override
    public String getCurrentUser() {
        return servletRequest.get().getRemoteUser();
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public boolean hasPermission(PermissionType permission, String organizationId) {
        return this.isAdmin() || this.getPermissions().hasQualifiedPermission(permission, organizationId);
    }

    @Override
    public boolean hasAllPermissions(Set<PermissionType> permissions, String organizationId) {
        return permissions.stream().allMatch(permTest -> this.hasPermission((PermissionType)permTest, organizationId));
    }

    @Override
    public boolean hasAnyPermission(Set<PermissionType> permissions, String organizationId) {
        return permissions.stream().anyMatch(permTest -> this.hasPermission((PermissionType)permTest, organizationId));
    }

    @Override
    public boolean isMemberOf(String organizationId) {
        if (this.isAdmin()) {
            return true;
        }
        return this.getPermissions().isMemberOf(organizationId);
    }

    @Override
    public Set<String> getPermittedOrganizations(PermissionType permission) {
        return this.getPermissions().getOrgQualifiers(permission);
    }

    @Override
    public Set<DiscoverabilityLevel> getPermittedDiscoverabilities() {
        return this.getDiscoverabilities();
    }

    private IndexedPermissions getPermissions() {
        IndexedPermissions rval = permissions.get();
        if (rval == null) {
            rval = this.loadPermissions();
            permissions.set(rval);
        }
        return rval;
    }

    private IndexedPermissions loadPermissions() {
        String userId = this.getCurrentUser();
        if (userId == null || userId.isBlank()) {
            return new IndexedPermissions(Collections.emptySet());
        }
        try {
            return new IndexedPermissions(this.query.getPermissions(userId));
        }
        catch (StorageException e) {
            LOGGER.error(Messages.getString("AbstractSecurityContext.ErrorLoadingPermissions") + userId, (Throwable)e);
            return new IndexedPermissions(new HashSet<PermissionBean>());
        }
    }

    @Override
    public void checkPermissions(PermissionType permission, String organizationId) throws NotAuthorizedException {
        if (!this.hasPermission(permission, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public void checkAllPermissions(Set<PermissionType> permissions, String organizationId) throws NotAuthorizedException {
        if (!this.hasAllPermissions(permissions, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public void checkAnyPermission(Set<PermissionType> permissions, String organizationId) throws NotAuthorizedException {
        if (!this.hasAnyPermission(permissions, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public void checkAdminPermissions() throws NotAuthorizedException {
        if (!this.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public void checkPermissionsOrDiscoverability(ISecurityContext.EntityType entityType, String orgId, String entityId, Set<PermissionType> permissionType) {
        if (!this.hasPermissionsOrDiscoverable(entityType, orgId, entityId, permissionType)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public void checkPermissionsOrDiscoverability(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion, Set<PermissionType> permissionType) {
        if (!this.hasPermissionsOrDiscoverable(entityType, orgId, entityId, entityVersion, permissionType)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public boolean hasPermissionsOrDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, Set<PermissionType> permissionType) {
        return this.hasPermissionsOrDiscoverable(entityType, orgId, entityId, null, permissionType);
    }

    @Override
    public boolean hasPermissionsOrDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion, Set<PermissionType> permissionType) {
        return this.hasAnyPermission(permissionType, orgId) || this.isDiscoverable(entityType, orgId, entityId, entityVersion);
    }

    @Override
    public boolean isDiscoverable(ISecurityContext.EntityType entityType, String organizationId, String entityId) {
        return this.isDiscoverable(entityType, organizationId, entityId, null);
    }

    @Override
    public boolean isDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion) {
        return this.isDiscoverable(entityType, orgId, entityId, entityVersion, this.getDiscoverabilities());
    }

    @Override
    public boolean isDiscoverable(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion, Set<DiscoverabilityLevel> discoverabilityLevelSet) {
        IndexedDiscoverabilities.DILookupResult indexedResult = this.isVis(entityType, orgId, entityId, entityVersion, discoverabilityLevelSet);
        switch (indexedResult) {
            case DISCOVERABLE: {
                return true;
            }
            case NOT_DISCOVERABLE: {
                return false;
            }
            case NOT_IN_INDEX: {
                IndexedDiscoverabilities indexedDiscoverabilities = discoverabilities.get();
                indexedDiscoverabilities.index(this.storage.getOrgApiPlansWithDiscoverability(orgId, Set.of(DiscoverabilityLevel.values())));
                IndexedDiscoverabilities.DILookupResult retry = this.isVis(entityType, orgId, entityId, entityVersion, discoverabilityLevelSet);
                return retry == IndexedDiscoverabilities.DILookupResult.DISCOVERABLE;
            }
        }
        throw new IllegalArgumentException("Unhandled index state: " + indexedResult);
    }

    private IndexedDiscoverabilities.DILookupResult isVis(ISecurityContext.EntityType entityType, String orgId, String entityId, String entityVersion, Set<DiscoverabilityLevel> discoverabilityLevelSet) {
        IndexedDiscoverabilities indexedDiscoverabilities = discoverabilities.get();
        if (entityVersion == null || entityVersion.isBlank()) {
            return indexedDiscoverabilities.isAnyDiscoverable(entityType, orgId, entityId, discoverabilityLevelSet);
        }
        return indexedDiscoverabilities.isDiscoverable(entityType, orgId, entityId, entityVersion, discoverabilityLevelSet);
    }

    private Set<DiscoverabilityLevel> getDiscoverabilities() {
        HttpServletRequest request = servletRequest.get();
        if (request.getRemoteUser() != null) {
            HashSet<DiscoverabilityLevel> discoverabilities = new HashSet<DiscoverabilityLevel>(4);
            this.discoverabilityConfig.getSourceToDiscoverability().forEach((source, discoverabilityConfig) -> {
                switch (source) {
                    case IDM_ROLE: {
                        if (!request.isUserInRole(discoverabilityConfig.getName())) break;
                        discoverabilities.addAll(discoverabilityConfig.getDiscoverabilities());
                        break;
                    }
                    case IDM_ATTRIBUTE: 
                    case APIMAN_ROLE: 
                    case APIMAN_PERMISSION: {
                        throw new UnsupportedOperationException("Support for " + source + " not available on this platform.");
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + source);
                    }
                }
            });
            if (discoverabilities.isEmpty()) {
                discoverabilities.add(DiscoverabilityLevel.PORTAL);
                discoverabilities.add(DiscoverabilityLevel.ANONYMOUS);
            }
            return discoverabilities;
        }
        return Set.of(DiscoverabilityLevel.PORTAL, DiscoverabilityLevel.ANONYMOUS);
    }

    @Override
    public void checkIfUserIsCurrentUser(String userId) throws NotAuthorizedException {
        if (!this.isAdmin() && !this.getCurrentUser().equals(userId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
    }

    @Override
    public List<UserDto> getUsersWithPermission(PermissionType permission, String orgName) {
        try {
            return this.storage.getAllUsersWithPermission(permission, orgName).stream().map(arg_0 -> ((UserMapper)userMapper).toDto(arg_0)).collect(Collectors.toList());
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract Locale getLocale();

    @Override
    public List<UserDto> getUsersWithRole(String roleName, String orgName) {
        try {
            return this.storage.getAllUsersWithRole(roleName, orgName).stream().map(arg_0 -> ((UserMapper)userMapper).toDto(arg_0)).collect(Collectors.toList());
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }
}

