/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.manager.api.beans.metrics.ClientUsagePerApiBean;
import io.apiman.manager.api.beans.metrics.HistogramIntervalType;
import io.apiman.manager.api.beans.metrics.ResponseStatsHistogramBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerClientBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerPlanBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsSummaryBean;
import io.apiman.manager.api.beans.metrics.UsageHistogramBean;
import io.apiman.manager.api.beans.metrics.UsagePerClientBean;
import io.apiman.manager.api.beans.metrics.UsagePerPlanBean;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.rest.exceptions.InvalidMetricCriteriaException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@ApplicationScoped
@Transactional
public class StatsService {
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static final long ONE_MONTH_MILLIS = 2592000000L;
    private IMetricsAccessor metrics;
    private ISecurityContext securityContext;

    @Inject
    public StatsService(IMetricsAccessor metrics, ISecurityContext securityContext) {
        this.metrics = metrics;
        this.securityContext = securityContext;
    }

    public StatsService() {
    }

    public UsagePerClientBean getUsagePerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getUsagePerClient(organizationId, apiId, version, from, to);
    }

    public ClientUsagePerApiBean getClientUsagePerApi(String organizationId, String clientId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getClientUsagePerApi(organizationId, clientId, version, from, to);
    }

    public UsageHistogramBean getUsage(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        if (interval == null) {
            interval = HistogramIntervalType.day;
        }
        this.validateMetricRange(from, to);
        this.validateTimeSeriesMetric(from, to, interval);
        return this.metrics.getUsage(organizationId, apiId, version, interval, from, to);
    }

    public UsagePerPlanBean getUsagePerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getUsagePerPlan(organizationId, apiId, version, from, to);
    }

    public ResponseStatsHistogramBean getResponseStats(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        if (interval == null) {
            interval = HistogramIntervalType.day;
        }
        this.validateMetricRange(from, to);
        this.validateTimeSeriesMetric(from, to, interval);
        return this.metrics.getResponseStats(organizationId, apiId, version, interval, from, to);
    }

    public ResponseStatsSummaryBean getResponseStatsSummary(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsSummary(organizationId, apiId, version, from, to);
    }

    public ResponseStatsPerClientBean getResponseStatsPerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsPerClient(organizationId, apiId, version, from, to);
    }

    public ResponseStatsPerPlanBean getResponseStatsPerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsPerPlan(organizationId, apiId, version, from, to);
    }

    private void validateMetricRange(DateTime from, DateTime to) throws InvalidMetricCriteriaException {
        if (from.isAfter((ReadableInstant)to)) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("OrganizationResourceImpl.InvalidMetricDateRange", new Object[0]));
        }
    }

    private void validateTimeSeriesMetric(DateTime from, DateTime to, HistogramIntervalType interval) throws InvalidMetricCriteriaException {
        long millis = to.getMillis() - from.getMillis();
        long divBy = 86400000L;
        switch (interval) {
            case day: {
                divBy = 86400000L;
                break;
            }
            case hour: {
                divBy = 3600000L;
                break;
            }
            case minute: {
                divBy = 60000L;
                break;
            }
            case month: {
                divBy = 2592000000L;
                break;
            }
            case week: {
                divBy = 604800000L;
                break;
            }
        }
        long totalDataPoints = millis / divBy;
        if (totalDataPoints > 5000L) {
            throw ExceptionFactory.invalidMetricCriteriaException((String)Messages.i18n.format("OrganizationResourceImpl.MetricDataSetTooLarge", new Object[0]));
        }
    }

    private DateTime parseFromDate(String fromDate) {
        DateTime defaultFrom = new DateTime().withZone(DateTimeZone.UTC).minusDays(30).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
        return StatsService.parseDate(fromDate, defaultFrom, true);
    }

    private DateTime parseToDate(String toDate) {
        return StatsService.parseDate(toDate, new DateTime().withZone(DateTimeZone.UTC), false);
    }

    private static DateTime parseDate(String dateStr, DateTime defaultDate, boolean floor) {
        if ("now".equals(dateStr)) {
            return new DateTime();
        }
        if (dateStr.length() == 10) {
            DateTime parsed = ISODateTimeFormat.date().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
            if (!floor) {
                parsed = parsed.plusDays(1).minusMillis(1);
            }
            return parsed;
        }
        if (dateStr.length() == 20) {
            return ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
        }
        if (dateStr.length() == 24) {
            return ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
        }
        return defaultDate;
    }
}

