/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.config.options.GenericOptionsParser;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.JsonUtil;
import io.apiman.common.util.Preconditions;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.idm.UserMapper;
import io.apiman.manager.api.beans.notifications.NotificationEntity;
import io.apiman.manager.api.beans.notifications.NotificationFilterEntity;
import io.apiman.manager.api.beans.notifications.NotificationPreferenceEntity;
import io.apiman.manager.api.beans.notifications.NotificationStatus;
import io.apiman.manager.api.beans.notifications.NotificationType;
import io.apiman.manager.api.beans.notifications.dto.CreateNotificationDto;
import io.apiman.manager.api.beans.notifications.dto.CreateNotificationFilterDto;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.beans.notifications.dto.RecipientDto;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.INotificationRepository;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.notifications.NotificationRulesService;
import io.apiman.manager.api.notifications.mappers.NotificationMapper;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApplicationScoped
@Transactional
public class NotificationService
implements DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(NotificationService.class);
    private NotificationServiceConfig config;
    private IStorage storage;
    private INotificationRepository notificationRepository;
    private NotificationMapper notificationMapper;
    private ISecurityContext securityContext;
    private Event<NotificationDto<?>> notificationDispatcher;
    private NotificationRulesService notificationRulesService;
    private UserMapper userMapper = UserMapper.INSTANCE;

    @Inject
    public NotificationService(ApiManagerConfig config, IStorage storage, INotificationRepository notificationRepository, NotificationMapper notificationMapper, Event<NotificationDto<?>> notificationDispatcher, ISecurityContext securityContext, NotificationRulesService notificationRulesService) {
        this.storage = storage;
        this.notificationRepository = notificationRepository;
        this.notificationMapper = notificationMapper;
        this.notificationDispatcher = notificationDispatcher;
        this.securityContext = securityContext;
        this.config = new NotificationServiceConfig(config.getNotificationsConfig());
        this.notificationRulesService = notificationRulesService;
    }

    public NotificationService() {
    }

    public int getNotificationsCount(@NotNull String recipientId, boolean unreadOnly) {
        if (unreadOnly) {
            LOGGER.debug("Getting unread notifications count for {0}", new Object[]{recipientId});
            return this.notificationRepository.countNotificationsByUserId(recipientId, List.of(NotificationStatus.OPEN));
        }
        LOGGER.debug("Getting all notifications count for {0}", new Object[]{recipientId});
        return this.notificationRepository.countNotificationsByUserId(recipientId, List.of(NotificationStatus.values()));
    }

    public SearchResultsBean<NotificationDto<?>> searchNotificationsByRecipient(@NotNull String recipientId, SearchCriteriaBean searchCriteriaBeanIn) {
        SearchCriteriaBean searchCriteria = new SearchCriteriaBean(searchCriteriaBeanIn);
        if (searchCriteriaBeanIn.getOrderBy() == null) {
            searchCriteria.setOrder("id", false);
        }
        SearchResultsBean results = this.tryAction(() -> this.notificationRepository.searchNotificationsByUser(recipientId, searchCriteria));
        List dtos = results.getBeans().stream().map(this.notificationMapper::entityToDto).collect(Collectors.toList());
        return new SearchResultsBean(dtos, results.getTotalSize());
    }

    public SearchResultsBean<NotificationDto<?>> getLatestNotificationsByRecipient(@NotNull String recipientId, @Nullable PagingBean paging) {
        SearchResultsBean results = this.tryAction(() -> this.notificationRepository.getLatestNotificationsByRecipientId(recipientId, paging));
        List dtos = results.getBeans().stream().map(this.notificationMapper::entityToDto).collect(Collectors.toList());
        return new SearchResultsBean(dtos, results.getTotalSize());
    }

    public void sendNotification(@NotNull CreateNotificationDto newNotification) {
        if (!this.config.isEnabled()) {
            LOGGER.trace("Notifications subsystem is disabled. Notification {0} will not be sent", new Object[]{newNotification});
            return;
        }
        LOGGER.debug("Creating new notification(s): {0}", new Object[]{newNotification});
        List<UserDto> resolvedRecipients = this.calculateRecipients(newNotification.getRecipient());
        for (UserDto resolvedRecipient : resolvedRecipients) {
            NotificationEntity notificationEntity = new NotificationEntity().setCategory(newNotification.getCategory()).setReason(newNotification.getReason()).setReasonMessage(newNotification.getReasonMessage()).setStatus(NotificationStatus.OPEN).setRecipient(resolvedRecipient.getUsername()).setSource(newNotification.getSource()).setPayload(JsonUtil.toJsonTree((Object)newNotification.getPayload()));
            this.tryAction(() -> {
                LOGGER.trace("Creating notification entity in repository layer: {0}", new Object[]{notificationEntity});
                this.notificationRepository.create(notificationEntity);
                NotificationDto<?> dto = this.toDto(notificationEntity, newNotification.getPayload(), resolvedRecipient);
                LOGGER.trace("Firing notification: {0}", new Object[]{dto});
                this.notificationDispatcher.fireAsync(dto).whenCompleteAsync((res, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error(throwable, "An error occurred in the asynchronous part of the notification subsystem. This error likely did not return directly to the requester: {0}", new Object[]{throwable.getMessage()});
                    }
                });
            });
        }
    }

    public void markNotificationsWithStatus(@NotNull String recipientId, @NotNull List<Long> notificationIds, @NotNull NotificationStatus status) {
        if (notificationIds.isEmpty()) {
            return;
        }
        LOGGER.trace("Marking recipient {0} notifications {1} as {2}", new Object[]{recipientId, notificationIds, status});
        this.tryAction(() -> this.notificationRepository.markNotificationsWithStatusById(recipientId, notificationIds, status));
    }

    public void markAllNotificationsReadByUserId(@NotNull String recipientId, @NotNull NotificationStatus status) {
        Preconditions.checkArgument((status != NotificationStatus.OPEN ? 1 : 0) != 0, (Object)("When marking all notifications as read a non-OPEN status must be provided: " + status));
        LOGGER.trace("Marking all recipient {0} notifications as read {1}");
        this.tryAction(() -> this.notificationRepository.markAllNotificationsReadByUserId(recipientId, status));
    }

    public boolean userWantsNotification(String userId, NotificationType notificationType, NotificationDto<?> notificationDto) {
        return this.notificationRulesService.wantsNotification(userId, notificationType, notificationDto);
    }

    public void createFilter(String userId, CreateNotificationFilterDto createFilter) {
        NotificationPreferenceEntity npe = this.notificationRepository.getNotificationPreferenceByUserIdAndType(userId, createFilter.getNotificationType()).orElseGet(() -> {
            NotificationPreferenceEntity newNpe = new NotificationPreferenceEntity().setType(createFilter.getNotificationType()).setUser((UserBean)this.storage.getEntityObjectReference(UserBean.class, (Object)userId));
            this.tryAction(() -> this.notificationRepository.create(newNpe));
            return newNpe;
        });
        NotificationFilterEntity nfe = this.notificationMapper.toEntity(createFilter);
        npe.getRules().add(nfe);
        this.tryAction(() -> this.notificationRepository.update(npe));
        this.notificationRulesService.cache(npe);
    }

    private List<UserDto> calculateRecipients(List<RecipientDto> recipientDto) {
        return recipientDto.stream().flatMap(recipient -> this.calculateRecipient((RecipientDto)recipient).stream()).collect(Collectors.toList());
    }

    private List<UserDto> calculateRecipient(RecipientDto recipient) {
        switch (recipient.getRecipientType()) {
            case INDIVIDUAL: {
                return Optional.ofNullable(this.tryAction(() -> this.storage.getUser(recipient.getRecipient()))).map(user -> List.of(this.userMapper.toDto(user))).orElse(Collections.emptyList());
            }
            case ROLE: {
                if (recipient.getOrgId() != null) {
                    return this.securityContext.getUsersWithRole(recipient.getRecipient(), recipient.getOrgId());
                }
                return this.securityContext.getRemoteUsersWithRole(recipient.getRecipient());
            }
            case PERMISSION: {
                PermissionType pType = PermissionType.valueOf((String)recipient.getRecipient());
                return this.securityContext.getUsersWithPermission(pType, recipient.getOrgId());
            }
        }
        throw new IllegalStateException("Unexpected value: " + recipient.getRecipientType());
    }

    private NotificationDto<?> toDto(NotificationEntity newNotification, IVersionedApimanEvent event, UserDto user) {
        return new NotificationDto().setId(newNotification.getId()).setCategory(newNotification.getCategory()).setReason(newNotification.getReason()).setReasonMessage(newNotification.getReasonMessage()).setStatus(NotificationStatus.OPEN).setCreatedOn(newNotification.getCreatedOn()).setModifiedOn(newNotification.getModifiedOn()).setRecipient(user).setSource(newNotification.getSource()).setPayload(event);
    }

    private static final class NotificationServiceConfig
    extends GenericOptionsParser {
        static final boolean DEFAULT_NOTIFICATIONS_ENABLED = true;
        private boolean enabled;

        public NotificationServiceConfig(Map<String, String> options) {
            super(options);
            this.parseOptions();
        }

        private void parseOptions() {
            this.enabled = this.getBool(NotificationServiceConfig.keys((Object[])new String[]{"enable"}), true);
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

