/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.Preconditions;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.idm.CurrentUserBean;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.UpdateUserBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.idm.UserMapper;
import io.apiman.manager.api.beans.idm.UserPermissionsBean;
import io.apiman.manager.api.beans.notifications.NotificationCriteriaBean;
import io.apiman.manager.api.beans.notifications.NotificationStatus;
import io.apiman.manager.api.beans.notifications.dto.CreateNotificationFilterDto;
import io.apiman.manager.api.beans.notifications.dto.NotificationActionDto;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IUserResource;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.SearchCriteriaUtil;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.NotificationService;
import io.apiman.manager.api.service.UserService;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.core.Response;

@ApplicationScoped
@Transactional
@PermitAll
public class UserResourceImpl
implements IUserResource,
DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(UserResourceImpl.class);
    private IStorage storage;
    private NotificationService notificationService;
    private UserService userService;
    private ISecurityContext securityContext;
    private IStorageQuery query;
    private INewUserBootstrapper userBootstrapper;
    private UserMapper userMapper = UserMapper.INSTANCE;

    @Inject
    public UserResourceImpl(IStorage storage, NotificationService notificationService, UserService userService, ISecurityContext securityContext, IStorageQuery query, INewUserBootstrapper userBootstrapper) {
        this.storage = storage;
        this.notificationService = notificationService;
        this.userService = userService;
        this.securityContext = securityContext;
        this.query = query;
        this.userBootstrapper = userBootstrapper;
    }

    public UserResourceImpl() {
    }

    public UserDto get(String userId) throws UserNotFoundException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.userMapper.toDto(this.userService.getUserById(userId));
    }

    public CurrentUserBean getInfo() {
        String userId = this.securityContext.getCurrentUser();
        return (CurrentUserBean)this.tryAction(() -> {
            CurrentUserBean currentUser = new CurrentUserBean();
            UserBean user = this.userService.getUserById(userId);
            if (user == null) {
                user = new UserBean();
                user.setUsername(userId);
                if (this.securityContext.getFullName() != null) {
                    user.setFullName(this.securityContext.getFullName());
                } else {
                    user.setFullName(userId);
                }
                if (this.securityContext.getEmail() != null) {
                    user.setEmail(this.securityContext.getEmail());
                } else {
                    user.setEmail("");
                }
                user.setJoinedOn(new Date());
                if (this.securityContext.getLocale() != null) {
                    user.setLocale(this.securityContext.getLocale());
                }
                this.storage.createUser(user);
                this.userBootstrapper.bootstrapUser(user, this.storage);
                currentUser.setPermissions(new HashSet());
            } else {
                LOGGER.debug("Got existing user: {0}", new Object[]{user});
                Set permissions = this.query.getPermissions(userId);
                currentUser.setPermissions(permissions);
                this.updateMutableFields(user);
            }
            currentUser.initFromUser(user);
            currentUser.setAdmin(this.securityContext.isAdmin());
            return currentUser;
        });
    }

    private void updateMutableFields(UserBean user) {
        boolean anyChanged = false;
        if (this.notNullOrNotEq(user.getLocale(), this.securityContext.getLocale())) {
            anyChanged = true;
            user.setLocale(this.securityContext.getLocale());
        }
        if (this.notNullOrNotEq(user.getEmail(), this.securityContext.getEmail())) {
            anyChanged = true;
            user.setEmail(this.securityContext.getEmail());
        }
        if (this.notNullOrNotEq(user.getFullName(), this.securityContext.getFullName())) {
            anyChanged = true;
            user.setFullName(this.securityContext.getFullName());
        }
        if (anyChanged) {
            LOGGER.debug("Updated user after detecting change(s) to mutable attributes: {0}", new Object[]{user});
            this.tryAction(() -> this.storage.updateUser(user));
        }
    }

    private boolean notNullOrNotEq(Object existingValue, Object newValue) {
        return newValue != null && !existingValue.equals(newValue);
    }

    public void update(String userId, UpdateUserBean user) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        this.userService.update(userId, user);
    }

    public List<OrganizationSummaryBean> getOrganizations(String userId) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.userService.getPermittedOrgs(userId);
    }

    public List<ClientSummaryBean> getClients(String userId) throws NotAuthorizedException, SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getClientsInternal(userId, PermissionType.clientView);
    }

    public List<ClientSummaryBean> getEditableClients(String userId) throws NotAuthorizedException, SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getClientsInternal(userId, PermissionType.clientEdit);
    }

    public List<ApiSummaryBean> getApis(String userId) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        Set<String> permittedOrganizations = this.getPermittedOrganizations(userId, PermissionType.apiView);
        return (List)this.tryAction(() -> this.query.getApisInOrgs(permittedOrganizations));
    }

    public SearchResultsBean<AuditEntryBean> getActivity(String userId, int page, int pageSize) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        try {
            PagingBean paging = PagingBean.create((int)page, (int)pageSize);
            return this.query.auditUser(userId, paging);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public UserPermissionsBean getPermissionsForUser(String userId) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return (UserPermissionsBean)this.tryAction(() -> {
            UserPermissionsBean bean = new UserPermissionsBean();
            bean.setUserId(userId);
            bean.setPermissions(this.query.getPermissions(userId));
            return bean;
        });
    }

    public SearchResultsBean<NotificationDto<?>> getNotificationsForUser(String userId, NotificationCriteriaBean criteria) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        SearchCriteriaUtil.validateSearchCriteria((SearchCriteriaBean)criteria);
        return this.notificationService.searchNotificationsByRecipient(userId, (SearchCriteriaBean)criteria);
    }

    public Response getNotificationCountForUser(String userId, boolean includeDismissed) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        boolean unreadOnly = !includeDismissed;
        int notificationCount = this.notificationService.getNotificationsCount(userId, unreadOnly);
        return Response.noContent().header("X-Total-Count", (Object)notificationCount).header("Total-Count", (Object)notificationCount).build();
    }

    public Response markNotifications(String userId, NotificationActionDto notificationAction) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        if (notificationAction.isMarkAll()) {
            Preconditions.checkArgument((notificationAction.getStatus() != NotificationStatus.OPEN ? 1 : 0) != 0, (Object)("When using markAll a non-OPEN status must be used: " + notificationAction.getStatus()));
            this.notificationService.markAllNotificationsReadByUserId(userId, notificationAction.getStatus());
        } else {
            this.notificationService.markNotificationsWithStatus(userId, notificationAction.getNotificationIds(), notificationAction.getStatus());
        }
        return Response.noContent().build();
    }

    public Response createNotificationFilter(String userId, CreateNotificationFilterDto createFilter) {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        this.notificationService.createFilter(userId, createFilter);
        return Response.accepted().build();
    }

    public List<OrganizationSummaryBean> getClientOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.clientEdit);
    }

    public List<OrganizationSummaryBean> getApiOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.apiEdit);
    }

    public List<OrganizationSummaryBean> getPlanOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.planEdit);
    }

    private Set<String> getPermittedOrganizations(String userId, PermissionType permissionType) {
        return this.userService.getPermissions(userId).stream().filter(permissionBean -> permissionBean.getName().equals((Object)permissionType)).map(PermissionBean::getOrganizationId).collect(Collectors.toSet());
    }

    private List<OrganizationSummaryBean> getOrganizationsInternal(String userId, PermissionType permissionType) throws SystemErrorException {
        return (List)this.tryAction(() -> this.query.getOrgs(this.getPermittedOrganizations(userId, permissionType)));
    }

    private List<ClientSummaryBean> getClientsInternal(String userId, PermissionType permissionType) throws SystemErrorException {
        try {
            return this.query.getClientsInOrgs(this.getPermittedOrganizations(userId, permissionType));
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }
}

